% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hydro_location.R
\name{get_hydro_location}
\alias{get_hydro_location}
\title{Get Hydro Location}
\usage{
get_hydro_location(indexes, flowpath)
}
\arguments{
\item{indexes}{data.frame as output from \link{index_points_to_lines}.}

\item{flowpath}{data.frame with three columns: id, frommeas, and tomeas
as well as geometry.}
}
\value{
sfc_POINT simple feature geometry list of length \code{nrow(indexes)}
}
\description{
given a flowline index, returns the hydrologic location (point)
along the specific linear element referenced by the index.
}
\examples{
if(require(nhdplusTools)) {
source(system.file("extdata", "sample_flines.R", package = "nhdplusTools"))

indexes <- index_points_to_lines(sample_flines,
                   sf::st_sfc(sf::st_sfc(list(sf::st_point(c(-76.86934, 39.49328)),
                                              sf::st_point(c(-76.91711, 39.40884)),
                                              sf::st_point(c(-76.88081, 39.36354))),
                              crs = 4326)))

get_hydro_location(indexes, sample_flines)
}
}
