% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darcy_weisbach.R
\name{darcyweisbach}
\alias{darcyweisbach}
\title{Solves the Darcy-Weisbach Equation for the either head loss (hf),
flow rate (Q), or diameter (D).}
\usage{
darcyweisbach(
  Q = NULL,
  D = NULL,
  hf = NULL,
  L = NULL,
  ks = NULL,
  nu = NULL,
  units = c("SI", "Eng")
)
}
\arguments{
\item{Q}{numeric vector that contains the flow rate [m^3/s or or ft^3/s]}

\item{D}{numeric vector that contains the pipe diameter [m or ft]}

\item{hf}{numeric vector that contains the head loss through the pipe section [m or ft]}

\item{L}{numeric vector that contains the pipe length [m or ft],}

\item{ks}{numeric vector that contains the 'equivalent sand roughness height
sand roughness height. Units should be consistent with other input [m or ft]}

\item{nu}{numeric vector that contains the kinematic viscosity of water,
[m2 s-1 or ft2 s-1].}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units. This is used for compatibility with iemisc package}
}
\value{
Returns a list including the missing parameter (hf, Q, or D):
\itemize{
  \item Q - flow rate.
  \item V - flow velocity.
  \item L - pipe length.
  \item hf - head loss due to friction
  \item f - Darcy-Weisbach friction factor
  \item Re - Reynolds number
}
}
\description{
This function solves the Darcy-Weisbach friction loss equation
for with water in circular pipes. the function solves for
either head loss (hf), flow rate (Q), or diameter (D),
whichever is missing (not included as an argument).
As with many parts of this package, techniques and formatting
were drawn from Irucka Embry's iemisc package, which includes some
methods with similar functionality.
}
\examples{

#Type 2 (solving for flow rate, Q): SI Units
D <- .5
L <- 10
hf <- 0.006*L
T <- 20
ks <- 0.000046
darcyweisbach(D = D, hf = hf, L = L, ks = ks, nu = kvisc(T=T, units='SI'), units = c('SI'))

#Type 3 (solving for diameter, D): Eng (US) units
Q <- 37.5     #flow in ft^3/s
L <- 8000     #pipe length in ft
hf <- 215     #head loss due to friction, in ft
T <- 68       #water temperature, F
ks <- 0.0008  #pipe roughness, ft
darcyweisbach(Q = Q, hf = hf, L = L, ks = ks, nu = kvisc(T=T, units='Eng'), units = c('Eng'))

}
