% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weir.R
\name{flow_depth_weir}
\alias{flow_depth_weir}
\title{Flow Depth At Weir Crest}
\usage{
flow_depth_weir(B, Q, w = Inf, mu = 0.73)
}
\arguments{
\item{B}{Width of the weir [m].}

\item{Q}{Flow rate [m3/s].}

\item{w}{Height of the weir crest (upstream) [m]. If w = Inf,
the upstream velocity is considered 0.}

\item{mu}{Discharge coefficient [-]. Default is 0.73.}
}
\value{
A list with the following components:
\describe{
  \item{h}{Flow depth over the weir [m].}
  \item{v}{Flow velocity [m/s].}
}
}
\description{
Calculates the height difference between the upstream water
  level and the weir crest.
}
\examples{
flow_depth_weir(B = 3, Q = 5)
flow_depth_weir(B = 3, Q = 5, w = 1)
}
