% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{getGaugingStationsMissing}
\alias{getGaugingStationsMissing}
\alias{getGaugingStationsMissing,WaterLevelDataFrame-method}
\alias{getGaugingStationsMissing-method}
\title{Extract a WaterLevelDataFrame's slot gauging_stations_missing}
\usage{
getGaugingStationsMissing(x)

\S4method{getGaugingStationsMissing}{WaterLevelDataFrame}(x)
}
\arguments{
\item{x}{an object of class \linkS4class{WaterLevelDataFrame}.}
}
\value{
The function above extracts the slot \code{gauging_stations_missing}
  and returns an object of class \code{character}, which might contain a
  vector with gauging stations without gauging data for the specified date.
}
\description{
A function to extract the slot \code{gauging_stations_missing}
  from an object of class \linkS4class{WaterLevelDataFrame}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("1991-12-16"),
                            station = seq(500, 501, 0.1))
wldf <- waterLevel(wldf)
getGaugingStationsMissing(wldf)

}
\seealso{
\code{\link[=setGaugingStationsMissing<-]{setGaugingStationsMissing<--method}}
}
