% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Initial.R
\name{Initial}
\alias{Initial}
\title{Creating initial parents\cr}
\usage{
Initial(X, y, EVAoutput, heredity = "Strong", r1, r2, numElite = 40)
}
\arguments{
\item{X}{Input data. An optional data frame, or numeric matrix of dimension
\code{n} observations by \code{p} main effects.}

\item{y}{Response variable. A \code{n}-dimensional vector.}

\item{EVAoutput}{The output from function \code{EVA}}

\item{heredity}{Whether to enforce Strong, Weak, or No heredity. Default is "Strong".}

\item{r1}{At most how many main effects do you want to include in your model?.
For high-dimensional data, \code{r1} cannot be larger than the number of
screened main effects.}

\item{r2}{At most how many interaction effects do you want to include in your model?}

\item{numElite}{Number of elite parents. Default is 40.}
}
\value{
Initial parents. A numeric matrix with dimensions \code{numElite} by \code{r1+r2}.
}
\description{
This function gives initial parents.
}
\examples{
set.seed(0)
interaction.ind <- t(combn(10,2))
X <- matrix(rnorm(100*10,1,0.1), 100, 10)
epl <- rnorm(100,0,0.01)
y <- 1+X[,1]+X[,2]+X[,3]+X[,1]*X[,2]+X[,1]*X[,3]+epl
EVAoutput <- EVA(X, y, r1 = 5, sigma = 0.01,
  interaction.ind = interaction.ind)
myParent <- Initial(X = X, y = y, EVAoutput, r1 = 5, r2 = 2)
}
\seealso{
\code{\link{EVA}}
}
