% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABC.R
\name{ABC}
\alias{ABC}
\title{ABC Evaluation\cr}
\usage{
ABC(
  X,
  y,
  heredity = "Strong",
  sigma,
  varind = NULL,
  interaction.ind = NULL,
  lambda = 10
)
}
\arguments{
\item{X}{Input data. An optional data frame, or numeric matrix of dimension
\code{n} observations by \code{p} main effects.}

\item{y}{Response variable. A \code{n}-dimensional vector.}

\item{heredity}{Whether to enforce Strong, Weak, or No heredity. Default is "Strong".}

\item{sigma}{The standard deviation of the noise term. In practice, sigma is usually
unknown. Users can estimate sigma from function \code{selectiveInference::estimateSigma},
then use the output as the sigma value. See examples for details.}

\item{varind}{A numeric vector that specifies the indices of variables to be extracted from \code{X}.
Default is "No".}

\item{interaction.ind}{A two-column numeric matrix. Each row represents a unique
interaction pair, with the columns indicating the index numbers of the variables
involved in each interaction. Note that interaction.ind must be generated
outside of this function using \code{t(utils::combn(p,2))}. See Example section for
details.}

\item{lambda}{A numeric value defined by users. The number needs to satisfy the condition:
\eqn{\lambda\geq 5.1/log(2)}. Default is 10.}
}
\value{
A numeric value is returned. It represents the ABC score of the fitted model.
}
\description{
Gives ABC score for each fitted model. For a model I, the ABC is defined as
\deqn{ABC(I)=\sum\limits_{i=1}^n\bigg(Y_i-\hat{Y}_i^{I}\bigg)^2+2r_I\sigma^2+\lambda\sigma^2C_I.}
When comparing ABC of fitted models to the same dataset, the smaller the ABC, the better fit.
}
\examples{
# When sigma is known
set.seed(0)
interaction.ind <- t(combn(4,2))
X <- matrix(rnorm(50*4,1,0.1), 50, 4)
epl <- rnorm(50,0,0.01)
y <- 1+X[,1]+X[,2]+X[,1]*X[,2] + epl
 ABC(X, y, sigma = 0.01, varind = c(1,2,5), interaction.ind = interaction.ind)

# When sigma is not known
full <- Extract(X, varind = c(1:(dim(X)[2]+dim(interaction.ind)[1])), interaction.ind)
sigma <- selectiveInference::estimateSigma(full, y)$sigmahat # Estimate sigma
}
\references{
Ye, C. and Yang, Y., 2019. \emph{High-dimensional adaptive minimax sparse estimation with interactions.}
}
