% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{meta.me}
\alias{meta.me}
\title{Meta-analysis using odds ratio and standard error from 2 datasets}
\usage{
meta.me(X, OR1 = "OR_CC", OR2 = "OR_Fam", SE1 = "SE_CC", SE2 = "SE_Fam",
  Z1 = NA, Z2 = NA, N1 = NA, N2 = NA, method = c("beta", "z.score",
  "sample.size"))
}
\arguments{
\item{X}{A data.frame with column names which should be entered in the parameters:
OR1, OR2, SE1, SE2, and optionally N1, N2.}

\item{OR1}{The column name of X containing odds ratios from the first analysis}

\item{OR2}{Same as OR1 above but pertaining to the second analysis}

\item{SE1}{The column name of X containing standard errors from the first analysis}

\item{SE2}{Same as SE1 above but pertaining to the second analysis}

\item{Z1}{Only use if method="sample.size" or "z.score". The column name in X with the 
z.scores in the first analysis.}

\item{Z2}{Same as Z1 above but pertaining to analysis 2}

\item{N1}{Only required if method="sample.size". Either the column name in X with the 
number of samples in the first analysis, of a vector of the same, or if N's is the
 same for all rows, a scalar' value can be entered
for each.}

\item{N2}{Only required if method="sample.size". Same as N1 above but pertaining to analysis 2}

\item{method}{character, can be either 'beta', 'z.score' or 'sample.size', and upper/lower
case does not matter. 'Beta' is the default and will calculate meta-analysis weights using
the inverse variance method (based on standard errors), and will calculate the p-values
based on the weighted beta coefficients of the two analyses. 'Z.score' also uses inverse variance
but calculates p-values based on the weighted Z scores of the two analyses. 'Sample.size' uses
the sqrt of the sample sizes to weight the meta analysis and uses Z scores to calculate p values
like 'Z.score' does.#'}
}
\value{
The object returned should have the same number of rows and rownames as the data.frame
 X but columns are the meta analysis stastistics, namely:
  OR.meta, beta.meta, se.meta, z.meta, p.meta, which will contain the meta
analysis odds-ratio, beta-coefficient, standard error, z-score, and p-values respectively
for each row of X.
}
\description{
This function calculates meta analysis odds ratios, standard errors and p-values
using results from a table containing odds ratio and standard error data for analyses
of 2 different datasets (typically logistic regression, but other analyses can be
incorporated if an odds-ratio and SE can be derived, for instance one analysis might
be a case control logistic regression GWAS and the other a family TDT analysis).
}
\examples{
X <- data.frame(OR_CC=c(1.8,1.15),OR_Fam=c(1.33,0.95),SE_CC=c(0.02,0.12),SE_Fam=c(0.07,0.5))
rownames(X) <- c("rs689","rs23444")
X
meta.me(X)
X <- data.frame(OR_CC=c(1.8,1.15),OR_CC2=c(1.33,0.95),
 SE_CC=c(0.02,0.12),SE_CC2=c(0.02,0.05),
 n1=c(5988,5844),n2=c(1907,1774))
# even with roughly the same number of samples the standard error will determine the influence of
# each analysis on the overall odds ratio, note here that the second SE for dataset goes
# from 0.5 to 0.05 and as a result the estimate of the odds ratio goes from 1.137 to 0.977,
# i.e, from very close to OR1, changing to very close to OR2.
meta.me(X,OR2="OR_CC2",SE2="SE_CC2") 
# sample size and z-score methods give similar (but distinct) results
meta.me(X,OR2="OR_CC2",SE2="SE_CC2",N1="n1",N2="n2",method="sample.size") 
meta.me(X,OR2="OR_CC2",SE2="SE_CC2",N1="n1",N2="n2",method="z.score")  # N's will be ignored
}
