% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{force.chr.pos}
\alias{force.chr.pos}
\title{Force a valid genomic range, given the inputted coordinates}
\usage{
force.chr.pos(Pos, Chr, snp.info = NULL, build = NULL, dir = NULL)
}
\arguments{
\item{Pos}{must be numeric, length 2, e.g, c(20321,30123)}

\item{Chr}{chromosome label}

\item{snp.info}{optional object to take boundaries from, the maxima and minima for each
chromosome within this object will take the place of the chromsome lengths / 1.}

\item{build}{ucsc build, only need to enter if this differs from getOption("ucsc")}

\item{dir}{directory to use for download of chromosome lengths (only if you wish to
keep the chromosome length file)}
}
\description{
Enter a pair of genomic locations representing a range for a given chromosome and this
function will ensure that no position is less than 1 or greater than the relevant chromosome
 lengths. Anything below will be coerced to 1, and anything above to the chromosome length.
}
\examples{
pss <- ps <- c(345035,345035); ch <- 1
force.chr.pos(ps,ch)
pss[1] <- 0
force.chr.pos(pss,ch) # won't allow zero
pss[1] <- -1
force.chr.pos(pss,ch) # won't allow negative
pss[1] <- 645035012
force.chr.pos(pss,ch) # won't allow pos > chromosome length
}

