% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_model.R
\name{solve_model}
\alias{solve_model}
\title{Solve_model}
\usage{
solve_model(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  times = NULL,
  parameters = NULL,
  model = NULL,
  route = "oral",
  dosing = NULL,
  days = 10,
  tsteps = 4,
  initial.values = NULL,
  initial.value.units = NULL,
  plots = FALSE,
  monitor.vars = NULL,
  suppress.messages = FALSE,
  species = "Human",
  input.units = "mg/kg",
  output.units = NULL,
  method = "lsoda",
  rtol = 1e-08,
  atol = 1e-12,
  recalc.blood2plasma = FALSE,
  recalc.clearance = FALSE,
  restrictive.clearance = TRUE,
  adjusted.Funbound.plasma = TRUE,
  minimum.Funbound.plasma = 1e-04,
  parameterize.arg.list = list(),
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{times}{Optional time sequence for specified number of output times (in days) to be returned by the function.
The model is solved explicitly at the time sequence specified. Dosing sequence begins at the first time provided.}

\item{parameters}{List of chemical parameters, as output by 
parameterize_pbtk function. Overrides chem.name and chem.cas.}

\item{model}{Specified model to use in simulation: "pbtk", "3compartment",
"3compartmentss", "1compartment", "schmitt", ...}

\item{route}{String specification of route of exposure for simulation:
"oral", "iv", "inhalation", ...}

\item{dosing}{List of dosing metrics used in simulation, which includes
the namesake entries of a model's associated dosing.params. In the case
of most httk models, these should include "initial.dose", "doses.per.day", 
"daily.dose", and "dosing.matrix". The "dosing.matrix" is used for more
precise dose regimen specification, and is a matrix consisting of two
columns or rows named "time" and "dose" containing the time and amount of 
each dose. If none of the namesake entries of the dosing list is set to a
non-NULL value, solve_model uses a default dose of 1 mg/kg BW along with the 
dose type (add/multiply) specified for a given route (e.g. add the dose to gut
lumen for oral route)}

\item{days}{Simulated period. Default 10 days.}

\item{tsteps}{The number of time steps per hour. Default of 4.}

\item{initial.values}{Vector of numeric values containing the initial
concentrations or amounts of the chemical in specified tissues with units
corresponding to those specified for the model outputs. Default values are zero.}

\item{initial.value.units}{Vector of character strings containing the units
corresponding to 'initial.values' specified for the model outputs.
Default is assuming the units match expected compartment units for the model.}

\item{plots}{Plots all outputs if true.}

\item{monitor.vars}{Which variables are returned as a function of time. 
Default values of NULL looks up variables specified in modelinfo_MODEL.R}

\item{suppress.messages}{Whether or not the output messages are suppressed.}

\item{species}{Species desired (models have been designed to be
parameterized for some subset of the following species: "Rat", "Rabbit", 
"Dog", "Mouse", or default "Human").}

\item{input.units}{Input units of interest assigned to dosing. Defaults
to mg/kg BW, in line with the default dosing scheme of a one-time dose of
1 mg/kg in which no other dosing parameters are specified.}

\item{output.units}{Output units of interest for the compiled components.
Defaults to NULL, and will provide values in model units if unspecified.}

\item{method}{Method used by integrator (deSolve).}

\item{rtol}{Argument passed to integrator (deSolve).}

\item{atol}{Argument passed to integrator (deSolve).}

\item{recalc.blood2plasma}{Recalculates the ratio of the amount of chemical
in the blood to plasma using the input parameters, calculated with
hematocrit, Funbound.plasma, and Krbc2pu.}

\item{recalc.clearance}{Recalculates the the hepatic clearance
(Clmetabolism) with new million.cells.per.gliver parameter.}

\item{restrictive.clearance}{Protein binding not taken into account (set to
1) in liver clearance if FALSE.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with partition coefficients calculated with this value.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset)}

\item{parameterize.arg.list}{Additional parameterized passed to the model
parameterization function.}

\item{...}{Additional arguments passed to the integrator.}
}
\value{
A matrix of class deSolve with a column for time(in days), each
compartment, the area under the curve, and plasma concentration and a row
for each time point.
}
\description{
solve_model is designed to accept systematized metadata (provided by the
model.list defined in the modelinfo files) for a given 
toxicokinetic model, including names of variables, parameterization
functions, and key units, and use it along with chemical information
to prepare an ode system for numerical solution over time of the amounts
or concentrations of chemical in different bodily compartments of a given
species (either "Rat", "Rabbit", "Dog", "Mouse", or default "Human").
}
\details{
Dosing values with certain acceptable associated input.units (like mg/kg BW)
are configured to undergo a unit conversion. All model simulations are 
intended to run with units as specifed by "compartment.units" in the 
model.list (as defined by the modelinfo files).

The 'dosing' argument includes all parameters needed to describe exposure
in terms of route of administration, frequency, and quantity short of 
scenarios that require use of a more precise forcing function. If the dosing
argument's namesake entries are left NULL, solve_model defaults to a
single-time dose of 1 mg/kg BW according to the given dosing route and 
associated type (either add/multiply, for example we typically add a dose to 
gut lumen 
when oral route is specified).

AUC is the area under the curve of the plasma concentration.

Model parameters are named according to the following convention:
\tabular{lrrrr}{
prefix \tab suffix \tab Meaning \tab units \cr
K \tab \tab Partition coefficient for tissue to free plasma \ tab unitless \cr
V \tab \tab Volume \tab L \cr
Q \tab \tab Flow \tab L/h \cr
k \tab \tab Rate \tab 1/h \cr
\tab c \tab Parameter is proportional to body weight \tab 1 / kg for volumes
and 1/kg^(3/4) for flows \cr}

When species is specified but chemical-specific in vitro data are not
available, the function uses the appropriate physiological data (volumes and
flows) but default.to.human = TRUE must be used to substitute human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.
(NOTE: The 'default.to.human' specification should be included as part of the
arguments listed in 'parameterize.arg.list'.)
 
For both plotting purposes and helping the numerical equation solver, it is
helpful to specify that time points shortly before and after dosing are 
included. This function automatically add these points, and they are returned
to the user unless the times argument is used, in which case only the time
points specified by that argument are provided.
}
\examples{
# The varrious "solve_x" functions are wrappers for solve_model:
head(solve_pbtk(chem.name="Terbufos", days=1))

head(solve_model(chem.name="Terbufos",model="pbtk",dosing=list(
                 initial.dose = 1, # Assume dose is in mg/kg BW/day  
                 doses.per.day=NULL,
                 dosing.matrix = NULL,
                 days=1,
                 daily.dose = NULL)))

# A dose matrix specifies times and magnitudes of doses:
dm <- matrix(c(0,1,2,5,5,5),nrow=3)
colnames(dm) <- c("time","dose")

solve_pbtk(chem.name="Methenamine",
           dosing.matrix=dm,
           dose=NULL,
           days=2.5,
           daily.dose=NULL)

solve_model(chem.name="Methenamine",model="pbtk",dosing=list(
            initial.dose =NULL,
            doses.per.day=NULL,
            daily.dose=NULL,
            days=2.5,
            dosing.matrix=dm))

solve_model(chem.name="Besonprodil",model="pbtk",dosing=list(
            initial.dose =NULL,
            doses.per.day=4,
            daily.dose=1,
            days=2.5,
            dosing.matrix=NULL))
  
solve_pbtk(chem.name="Besonprodil",
           daily.dose=1,
           dose=NULL,
           doses.per.day=4,
           days=2.5)

}
\references{
\insertRef{pearce2017httk}{httk}
}
\author{
John Wambaugh, Robert Pearce, Miyuki Breen, Mark Sfeir, and
Sarah E. Davidson
}
\keyword{Solve}
