% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_month.R
\name{h_month}
\alias{h_month}
\title{Monthly operations, based on a daily time-series}
\usage{
h_month(
  file,
  op = "M",
  ba = NA,
  rmna = FALSE,
  climedit = FALSE,
  caledit_j = FALSE,
  caledit_m = FALSE,
  gapfill = FALSE,
  hts_year = FALSE
)
}
\arguments{
\item{file}{Full file name of the daily time-series.}

\item{op}{Operation: mean ("M") or sum ("S")}

\item{ba}{Basin area in km2 or NA (default)}

\item{rmna}{Remove NA values TRUE / FALSE (default)}

\item{climedit}{Write a climatology file TRUE / FALSE (default)}

\item{caledit_j}{Write an Excel file with daily calendar TRUE / FALSE (default)}

\item{caledit_m}{Write an Excel file with monthly calendar TRUE / FALSE (default)}

\item{gapfill}{Replace the missing months by the "climatology" value TRUE / FALSE
(default)}

\item{hts_year}{Extract the mean, max & min yearly values in hts files
TRUE / FALSE (default)}
}
\value{
A list of timeSeries class objects including:
[1] raw monthly data;
[2] 12 climatology means (January to December);
[3] gapfilled monthly data, if the option gapfill is TRUE.

Three hts time series files: a monthly data file with the suffix _M, a climatology data
file with the suffix _C and, optionnally, a gapfilled monthly data file with
the suffix _G.

Optionnaly, two Excel files with calendar presented values:, one with
daily data and one with monthly data, the fist one with a ad_ prefix and the
second one with the am_ prefix.
}
\description{
Monthly operations, based on a daily time-series
}
\details{
Based on a daily time-series, the function returns a monthly
time-series, and computes a mean monthly climatology. It allows to consider or
not the missing daily values: option rmna.

The function can also produce Excel files: with a calendar presentation (days
in rows, months in columns, years in sheets): option caledit_j ; with the
monthly means (or sums): option caledit_m. In addition, the missing values can
be replaced by the mean of the existing values for other years : option gapfill.

Climatology files are by convention attibuted to year 2000.

Generally, the values of the monthly climatologies are mean values (op="M"),
except if they are vomumes (e.g.: precipitation, evaporation,
etc.). In these cases, the parameter op="S" must be precised.

If rmna = TRUE , the NA values are not taken into consideration for computing
the sum or the mean.

In the case of discharge values, it is possible to compute monthly volumes
expressed in mm. Thatfore, the basin area ba must be given in km2.

By default, the reference name of the time-series is <sensor.id>_<station.id>.
It is possible to change it giving a value to the parameter ref.
}
\examples{
\dontrun{

res <- h_month("foo.ts",op="S", ba=135, caledit_m = TRUE)
}

}
\author{
P. Chevallier - Oct 2017- Apr 2020
}
