% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rao}
\alias{rao}
\title{System of genetic mapping functions}
\usage{
rao(p, x)
}
\arguments{
\item{p}{mixing parameter (see details); \code{0 <= p <= 1}}

\item{x}{vector of recombination rates}
}
\value{
vector of genetic positions in Morgan units
}
\description{
Calculation of genetic distances from recombination rates given
  a mixing parameter
}
\details{
Mixing parameter \code{p=0} would match to Morgan, \code{p=0.25} to
  Carter, \code{p=0.5} to Kosambi and \code{p=1} to Haldane map function
}
\examples{
  rao(0.25, seq(0, 0.5, 0.01))
}
\references{
Rao, D.C., Morton, N.E., Lindsten, J., Hulten, M. & Yee, S (1977)
  A mapping function for man. Human Heredity 27: 99-104.
  \doi{10.1159/000152856}
}
