% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{polynomialIndex}
\alias{polynomialIndex}
\title{Returns matrix of polynomial indexes}
\usage{
polynomialIndex(pol_degrees = 0L)
}
\arguments{
\item{pol_degrees}{non-negative integer vector of polynomial degrees.}
}
\value{
This function returns polynomial indexes matrix which rows are responsible 
for variables while columns are related to powers.
}
\description{
Returns matrix of polynomial indexes for the polynomial with degrees (orders) vector \code{pol_degrees}.
}
\details{
This function motivation is to have an opportunity to
iterate through the columns of polynomial indexes matrix in order to access polynomial elements 
being aware of their powers.
}
\examples{
## Get polynomial indexes matrix for the polynomial 
## which degrees are (1, 3, 5)

polynomialIndex(c(1, 3, 5))

\donttest{
## Consider polynomial of degrees (2, 1) such that coefficients
## for elements which powers sum is even are 2 and for those which powers
## are odd are 5. So the polynomial is 2+5y+5x+2xy+2x^2+5yx^2.

# Let's represent its powers (not coefficients) in a matrix form
pol_matrix <- polynomialIndex(c(2, 1))

# Suppose we want to calculate this polynomial coefficients sum:
powers_sum <- 0

# For pedagogical reasons iterate throught the pol_matrix columns
pol_matrix_length = dim(pol_matrix)[2]

for (i in 1:pol_matrix_length) 
{
	if ((pol_matrix[1, i] + pol_matrix[2, i]) \%\% 2 == 0)
	{
	  powers_sum <- powers_sum + 2
	} else {
	  powers_sum <- powers_sum + 5
	}
}
# powers_sum value will be 21
}
}
