% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_importance.R
\name{Variable_importance}
\alias{Variable_importance}
\title{Variable Importance plot}
\usage{
Variable_importance(model, top = NULL, var_names = NULL)
}
\arguments{
\item{model}{list containing a model of class "hs_rulefit".}

\item{top}{If a integer number is given only shows the top most important variables in the plot}

\item{var_names}{optional vector with the variable names to be shown in plot.}
}
\description{
Creates a input variable importance plot
}
\examples{
#Fit HorseRuleFit
x = matrix(rnorm(5000), ncol=10)
y = apply(x,1,function(x)sum(x[1:5])+rnorm(1))
hrres = HorseRuleFit(X = x, y=y,
                     thin=1, niter=100, burnin=10,
                     L=5, S=6, ensemble = "both", mix=0.3, ntree=100,
                     intercept=FALSE, linterms=1:10,
                     alpha=1, beta=2, linp = 1, restricted = 0)
Variable_importance(hrres)
}
