% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kp_ratings_tables.R
\name{kp_playerstats}
\alias{kp_playerstats}
\title{\strong{Get Player Stats Leaders by Metric}}
\usage{
kp_playerstats(
  metric = "eFG",
  conf = NULL,
  conf_only = FALSE,
  year = most_recent_mbb_season()
)
}
\arguments{
\item{metric}{Used to get leaders for different metrics. Available values are: \cr
'ORtg', 'Min', 'eFG', 'Poss', Shots', 'OR', 'DR', 'TO', 'ARate', 'Blk', \cr
'FTRate', 'Stl', 'TS', 'FC40', 'FD40', '2P', '3P', 'FT'. \cr
Default is 'eFG'. 'ORtg' returns a list of four dataframes, as there are four tables: \cr
players that used more than 28 percent of possessions, more than 24 percent of possessions, more than 20 percent of possessions, and with no possession restriction.}

\item{conf}{Used to limit to players in a specific conference. Allowed values are: 'A10', 'ACC', 'AE', 'AMER', \cr
'ASUN', 'B10', 'B12', 'BE', 'BSKY', 'BSTH', 'BW', 'CAA', 'CUSA', 'HORZ', 'IND', IVY', \cr
'MAAC', 'MAC', 'MEAC', 'MVC', 'MWC', 'NEC', 'OVC', 'P12', 'PAT', 'SB', 'SC', 'SEC', 'SLND', \cr
'SUM', 'SWAC', 'WAC', 'WCC'. \cr
If you try to use a conference that doesn't exist for a given season, like 'IND' and '2018', \cr
you'll get an empty table, as kenpom.com doesn't serve 404 pages for invalid table queries like that.\cr
No filter applied by default.}

\item{conf_only}{Used to define whether stats should reflect conference games only.\cr
Only available if specific conference is defined. Only available for season after 2013, FALSE by default.}

\item{year}{Year of data to pull (earliest year of data available: 2004)}
}
\value{
Returns a tibble of player stats
}
\description{
\strong{Get Player Stats Leaders by Metric}
}
\examples{
\donttest{
 try(kp_playerstats(metric = 'eFG', conf_only = FALSE, year=2021))
}
}
\keyword{Player}
