% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implausibility.R
\name{nth_implausible}
\alias{nth_implausible}
\title{nth Maximum Implausibility}
\usage{
nth_implausible(
  ems,
  x,
  z,
  n = NULL,
  max_imp = Inf,
  cutoff = NULL,
  sequential = FALSE,
  get_raw = FALSE,
  ordered = FALSE,
  ...
)
}
\arguments{
\item{ems}{A set of \code{\link{Emulator}} objects or nested sets thereof (see description)}

\item{x}{An input point, or \code{data.frame} of points.}

\item{z}{The target values, in the usual form or nested thereof.}

\item{n}{The implausibility level to return.}

\item{max_imp}{A maximum implausibility to return (often used with plotting)}

\item{cutoff}{A numeric value, or vector of such, representing allowed implausibility}

\item{sequential}{Should the emulators be evaluated sequentially?}

\item{get_raw}{Boolean - determines whether nth-implausibility should be applied.}

\item{ordered}{If FALSE, emulators are ordered according to restrictiveness.}

\item{...}{Any additional arguments to pass to chained functions (e.g. \code{ordering}
to pass to \code{collect_emulators})}
}
\value{
Either the nth maximum implausibilities, or booleans (if cutoff is given).
}
\description{
Computes the nth-maximum implausibility of points relative to a set of emulators.
}
\details{
For a collection of emulators, we often combine the implausibility
measures for a given set of observations. The maximum implausibility of a point,
given a set of univariate emulators and an associated collection of target values,
is the largest implausibility of the collected set of implausibilities. The 2nd
maximum is the maximum of the set without the largest value, and so on. By default,
maximum implausibility will be considered when there are fewer than 10 targets to
match to; otherwise second-maximum implausibility is considered.

If \code{sequential = TRUE} and a specific \code{cutoff} has been provided, then the
emulators' implausibility will be evaluated one emulator at a time. If a point
is judged non-implausible by more than \code{n} emulators, \code{FALSE} is
returned without evaluating any more. Due to R efficiencies, this is more efficient
than the 'evaluate all' method once more than around 10 emulators are considered.

This function also deals with variance emulators and bimodal emulators, working in a nested
fashion. If targets are provided for both the expectation and variance as a list, then
given \code{ems = list(expectation = ..., variance = ...)} the implausibility is calculated
with respect to both sets of emulators, maximising as relevant. If targets are provided in
the 'normal' fashion, then only the mean emulators are used. The bimodal case is similar;
given a set of emulators \code{list(mode1 = list(expectation = ..., variance = ...), ...)}
then each mode has implausibility evaluated separately. The results from the two modes are
combined via piecewise minimisation.
}
\examples{
# A single point
nth_implausible(SIREmulators$ems, data.frame(aSI = 0.4, aIR = 0.25, aSR = 0.025),
 SIREmulators$targets)
# A data.frame of points
grid <- expand.grid(
 aSI = seq(0.1, 0.8, length.out = 4),
 aIR = seq(0, 0.5, length.out = 4),
 aSR = seq(0, 0.05, length.out = 4)
)
# Vector of numerics
i1 <- nth_implausible(SIREmulators$ems, grid, SIREmulators$targets)
# Vector of booleans (same as i1 <= 3)
i2 <- nth_implausible(SIREmulators$ems, grid, SIREmulators$targets, cutoff = 3)
# Throws a warning as n > no. of targets
i3 <- nth_implausible(SIREmulators$ems, grid, SIREmulators$targets, n = 4)
# Vector of booleans (note different output to i2)
i4 <- nth_implausible(SIREmulators$ems, grid, SIREmulators$targets,
 cutoff = c(4, 2.5, 2))

# Variance Emulators
v_ems <- emulator_from_data(BirthDeath$training, c('Y'),
 list(lambda = c(0, 0.08), mu = c(0.04, 0.13)), emulator_type = "variance")
v_targs = list(expectation = list(Y = c(90, 110)), variance = list(Y = c(55, 95)))
nth_implausible(v_ems, unique(BirthDeath$validation[,1:2]), v_targs)
## If there is a mismatch between emulators and targets, expectation is assumed
nth_implausible(v_ems$expectation, unique(BirthDeath$validation[,1:2]), v_targs)
nth_implausible(v_ems, unique(BirthDeath$validation[,1:2]), v_targs$expectation)

}
