% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele-count-mism.R
\name{CountAlleleMism}
\alias{CountAlleleMism}
\title{Count HLA mismatch at the allele level}
\usage{
CountAlleleMism(dat_in, names_in)
}
\arguments{
\item{dat_in}{A data frame with donor and recipient mismatched alleles. It's a output from EvalAlleleMism function.}

\item{names_in}{A vector of HLA loci name to count mismatch for.}
}
\value{
A tibble of input data (subject id and hla loci) followed by mismatch hla count of each subject.
}
\description{
Donor and recipient HLA(Human Leukocyte Antigen) typing data is compared to determine allele level mismatch. The output of EvalAlleleMism is used as input for this function. Allele level mismatch can be calculated for both high and low resolution data. The generated count will return NA if the input alleles are NA.
}
\examples{
hla <- read.csv(system.file("extdata/example", "HLA_MisMatch_count_test.csv", package = "hlaR"))
classI <- CountAlleleMism(hla, c("mism.a1", "mism.a2", "mism.b1", "mism.b2"))
classII <- CountAlleleMism(hla, c("mism.dqa12", "mism.dqb11", "mism.dqb12"))
}
