% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hit.R
\name{hit}
\alias{hit}
\title{Hierarchical Inference Testing}
\usage{
hit(x, y, hierarchy, family = "gaussian", B = 50, p.samp1 = 0.35,
  nfolds = 10, lambda.opt = "lambda.1se", alpha = 1, gamma = seq(0.05,
  0.99, length.out = 100), max.p.esti = 1, mc.cores = 1L, trace = FALSE,
  ...)
}
\arguments{
\item{x}{Design matrix of dimension \code{n * p}, without intercept.
Variables not part of the dendrogram are added to the HO-model, see Details
below.}

\item{y}{Quantitative response variable dimension \code{n}.}

\item{hierarchy}{Object of class \code{\link{as.hierarchy}}. Must include
all variables of \code{x} which should be tested.}

\item{family}{Family of response variable distribution. Ether \code{y} is
"gaussian" in which case \code{y} must be a vector or it is "binomial"
distibuded. In this case \code{y} should be either a factor with two levels,
or a two-column matrix of counts or proportions (the second column is
treated as the target class; for a factor, the last level in alphabetical
order is the target class). For "binomial" if \code{y} is presented as a
vector, it will be coerced into a factor.}

\item{B}{Number of sample-splits.}

\item{p.samp1}{Fraction of data used for the LASSO. The ANOVA uses
\code{1 - p.samp1}.}

\item{nfolds}{Number of folds (default is 10). See
\code{\link[glmnet]{cv.glmnet}} for more details.}

\item{lambda.opt}{Criterion for optimum selection of cross-validated lasso.
Either "lambda.1se" (default) or "lambda.min". See
\code{\link[glmnet]{cv.glmnet}} for more details.}

\item{alpha}{A single value or a vector of values in the range of 0 to 1 for
the elastic net mixing parameter. If more than one value are given, the best
is selected during cross-validation.}

\item{gamma}{Vector of gamma-values.}

\item{max.p.esti}{Maximum alpha level. All p-values above this value are set
to one. Small \code{max.p.esti} values reduce computing time.}

\item{mc.cores}{Number of cores for parallelising. Theoretical maximum is
'B'. For details see \code{\link[parallel]{mclapply}}.}

\item{trace}{If TRUE it prints current status of the program.}

\item{...}{Additional arguments for \code{\link[glmnet]{cv.glmnet}}.}
}
\description{
Hierarchical inference testing for linear models with
high-dimensional and/or correlated covariates by repeated sample splitting.
}
\details{
The H0-model contains variables, with are not tested, like
experimental-design variables. These variables are not penalised in the
LASSO model selection and are always include in the reduced ANOVA model.
}
\examples{

# Simulation:
set.seed(123)
n <- 80
p <- 82
## x with correlated columns
corMat <- toeplitz((p:1/p)^5)
corMatQ <- chol(corMat)
x <- matrix(rnorm(n * p), nrow = n) \%*\% corMatQ
colnames(x) <- paste0("x", 1:p)
## y
mu <- x[, c(5, 24, 72)] \%*\% c(3, 1, 2)
y <-  rnorm(n, mu)
## clustering of the clumns of x
hc <- hclust(dist(t(x)))

# HIT with AF
out <- hit(x, y, hc)
summary(out)

}
\references{
Mandozzi, J. and Buehlmann, P. (2013). \emph{Hierarchical
testing in the high-dimensional setting with correlated variables}. To
appear in the Journal of the American Statistical Association. Preprint
arXiv:1312.5556
}

