% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hbl_mcmc_hierarchical.R
\name{hbl_mcmc_hierarchical}
\alias{hbl_mcmc_hierarchical}
\title{Longitudinal hierarchical MCMC}
\usage{
hbl_mcmc_hierarchical(
  data,
  response = "response",
  study = "study",
  study_reference = max(data[[study]]),
  group = "group",
  group_reference = min(data[[group]]),
  patient = "patient",
  rep = "rep",
  rep_reference = min(data[[rep]]),
  covariates = grep("^covariate", colnames(data), value = TRUE),
  constraint = FALSE,
  s_delta = 30,
  s_beta = 30,
  s_sigma = 30,
  s_lambda = 1,
  s_mu = 30,
  s_tau = 30,
  covariance_current = "unstructured",
  covariance_historical = "unstructured",
  control = list(max_treedepth = 17, adapt_delta = 0.99),
  ...
)
}
\arguments{
\item{data}{Tidy data frame with one row per patient per rep,
indicator columns for the response variable,
study, group, patient, rep,
and covariates. All columns must be atomic vectors
(e.g. not lists).}

\item{response}{Character of length 1,
name of the column in \code{data} with the response/outcome variable.
\code{data[[response]]} must be a continuous variable,
and it \emph{should} be the change from baseline of a
clinical endpoint of interest, as opposed to just
the raw response. Treatment differences
are computed directly from this scale, please supply
change from baseline unless you are absolutely certain
that treatment differences computed directly from
this quantity are clinically meaningful.}

\item{study}{Character of length 1,
name of the column in \code{data} with the study ID.}

\item{study_reference}{Atomic of length 1,
element of the \code{study} column that indicates
the current study.
(The other studies are historical studies.)}

\item{group}{Character of length 1,
name of the column in \code{data} with the group ID.}

\item{group_reference}{Atomic of length 1,
element of the \code{group} column that indicates
the control group.
(The other groups may be treatment groups.)}

\item{patient}{Character of length 1,
name of the column in \code{data} with the patient ID.}

\item{rep}{Character of length 1,
name of the column in \code{data} with the rep ID.}

\item{rep_reference}{Atomic of length 1,
element of the \code{rep} column that indicates
baseline, i.e. the first rep chronologically.
(The other reps may be post-baseline study visits or time points.)}

\item{covariates}{Character vector of column names
in \code{data} with the columns with baseline covariates.
These can be continuous, categorical, or binary.
Regardless, \code{historicalborrowlong} derives the appropriate
model matrix.

Each baseline covariate column must truly be a \emph{baseline} covariate:
elements must be equal for all time points within each patient
(after the steps in the "Data processing" section).
In other words, covariates must not be time-varying.

A large number of covariates, or a large number of levels in a
categorical covariate, can severely slow down the computation.
Please consider carefully if you really need to include
such complicated baseline covariates.}

\item{constraint}{Logical of length 1, whether to pool all study arms
at baseline (first rep). Appropriate when the response is the raw
response (as opposed to change from baseline) and the first rep
(i.e. time point) is prior to treatment.}

\item{s_delta}{Numeric of length 1, prior standard deviation
of the study-by-group effect parameters \code{delta}.}

\item{s_beta}{Numeric of length 1, prior standard deviation
of the fixed effects \code{beta}.}

\item{s_sigma}{Numeric of length 1, prior upper bound
of the residual standard deviations.}

\item{s_lambda}{shape parameter of the LKJ priors
on the unstructured correlation matrices.}

\item{s_mu}{Numeric of length 1,
prior standard deviation of \code{mu}.}

\item{s_tau}{Numeric of length 1,
Upper bound on \code{tau}.}

\item{covariance_current}{Character of length 1,
covariance structure of the current study.
Possible values are \code{"unstructured"} for fully parameterized
covariance matrices, \code{"ar1"} for AR(1) covariance matrices,
and \code{"diagonal"} for residuals independent across time within
each patient. In MCMC (e.g. \code{\link[=hbl_mcmc_hierarchical]{hbl_mcmc_hierarchical()}}),
the covariance structure affects computational speed.
Unstructured covariance is slower than AR(1), and AR(1) is slower
than diagonal. This is particularly true for \code{covariance_historical}
if there are many historical studies in the data.}

\item{covariance_historical}{Same as \code{covariance_current},
but for the covariance structure of each separate historical study.
Each historical study has its own separate covariance matrix.}

\item{control}{A named \code{list} of parameters to control the sampler's
    behavior. It defaults to \code{NULL} so all the default values are used. 
    First, the following are adaptation parameters for sampling algorithms.
    These are parameters used in Stan with similar names here.
    \itemize{
      \item \code{adapt_engaged} (\code{logical})
      \item \code{adapt_gamma} (\code{double}, positive, defaults to 0.05)
      \item \code{adapt_delta} (\code{double}, between 0 and 1, defaults to 0.8)
      \item \code{adapt_kappa} (\code{double}, positive, defaults to 0.75)
      \item \code{adapt_t0} (\code{double}, positive, defaults to 10)
      \item \code{adapt_init_buffer} (\code{integer}, positive, defaults to 75)
      \item \code{adapt_term_buffer} (\code{integer}, positive, defaults to 50)
      \item \code{adapt_window} (\code{integer}, positive, defaults to 25)
    }

    In addition, algorithm HMC (called 'static HMC' in Stan) and NUTS share the
    following parameters:
    \itemize{
      \item \code{stepsize} (\code{double}, positive)
      \item \code{stepsize_jitter} (\code{double}, [0,1])
      \item \code{metric} (\code{string}, one of "unit_e", "diag_e", "dense_e")
    }
    For algorithm NUTS, we can also set:
    \itemize{
      \item \code{max_treedepth} (\code{integer}, positive)
    }
    For algorithm HMC, we can also set:
    \itemize{
      \item \code{int_time} (\code{double}, positive)
    }
    
    For \code{test_grad} mode, the following parameters can be set:
    \itemize{
      \item \code{epsilon} (\code{double}, defaults to 1e-6)
      \item \code{error} (\code{double}, defaults to 1e-6)
    }
  }

\item{...}{Other optional parameters: 
    \itemize{
      \item \code{chain_id} (\code{integer})
      \item \code{init_r} (\code{double}, positive)
      \item \code{test_grad} (\code{logical})
      \item \code{append_samples} (\code{logical})
      \item \code{refresh}(\code{integer})
      \item \code{save_warmup}(\code{logical})
      \item deprecated: \code{enable_random_init}(\code{logical}) 
    }

    \code{chain_id} can be a vector to specify the chain_id for all 
    chains or an integer. For the former case, they should be unique. 
    For the latter, the sequence of integers starting from the given
    \code{chain_id} are used for all chains. 

    \code{init_r} is used only for generating random initial values,
    specifically when \code{init="random"} or not all parameters
    are initialized in the user-supplied list or function. If specified, 
    the initial values are simulated uniformly from interval 
    [-\code{init_r}, \code{init_r}] rather than using the default interval 
    (see the manual of (cmd)Stan).
    
    \code{test_grad} (\code{logical}).  
    If \code{test_grad=TRUE}, Stan will not do any sampling. Instead,
    the gradient calculation is tested and printed out and the fitted
    \code{stanfit} object is in test gradient mode.  By default, it is
    \code{FALSE}.
    
    \code{append_samples} (\code{logical}). 
    Only relevant if \code{sample_file} is specified \emph{and} is an 
    existing file. In that case, setting \code{append_samples=TRUE} will append 
    the samples to the existing file rather than overwriting the contents of 
    the file.

    \code{refresh} (\code{integer}) can be used to
    control how often the progress of the sampling is reported (i.e. 
    show the progress every \code{refresh} iterations). 
    By default, \code{refresh = max(iter/10, 1)}. 
    The progress indicator is turned off if \code{refresh <= 0}.

    Deprecated: \code{enable_random_init} (\code{logical}) being \code{TRUE}
    enables specifying initial values randomly when the initial
    values are not fully specified from the user. 
    
    \code{save_warmup} (\code{logical}) indicates whether to 
    save draws during the warmup phase and defaults to \code{TRUE}. Some
    memory related problems can be avoided by setting it to \code{FALSE},
    but some diagnostics are more limited if the warmup draws are not
    stored.
  }
}
\value{
A tidy data frame of parameter samples from the
posterior distribution. Columns \code{.chain}, \code{.iteration},
and \code{.draw} have the meanings documented in the
\code{posterior} package.
}
\description{
Run the longitudinal hierarchical model with MCMC.
}
\section{Data processing}{

Before running the MCMC, dataset is pre-processed.
This includes expanding the rows of the data so every rep
of every patient gets an explicit row. So if your
original data has irregular rep IDs, e.g. unscheduled
visits in a clinical trial that few patients attend,
please remove them before the analysis. Only the most
common rep IDs should be added.

After expanding the rows, the function fills in missing
values for every column except the response. That includes
covariates. Missing covariate values are filled in,
first with last observation carried forward,
then with last observation carried backward.
If there are still missing values after this process,
the program throws an informative error.
}

\examples{
if (!identical(Sys.getenv("HBL_TEST", unset = ""), "")) {
set.seed(0)
data <- hbl_sim_hierarchical(
  n_study = 2,
  n_group = 2,
  n_patient = 5,
  n_rep = 3
)$data
tmp <- utils::capture.output(
  suppressWarnings(
    mcmc <- hbl_mcmc_hierarchical(
      data,
      chains = 1,
      warmup = 10,
      iter = 20,
      seed = 0
    )
  )
)
mcmc
}
}
\seealso{
Other mcmc: 
\code{\link{hbl_convergence}()},
\code{\link{hbl_mcmc_independent}()},
\code{\link{hbl_mcmc_pool}()},
\code{\link{hbl_mcmc_sge}()}
}
\concept{mcmc}
