% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback}
\alias{callback}
\alias{ChunkCallback}
\alias{HipChunkCallback}
\alias{HipSideEffectChunkCallback}
\alias{HipListCallback}
\alias{HipDataFrameCallback}
\title{Callback classes}
\description{
These classes are used to define callback behaviors, and are based
on readr's \code{\link[readr:callback]{readr::callback}} functions.
}
\details{
\itemize{
\item The callbacks \code{HipChunkCallback}, \code{HipListCallback} and
\code{HipSideEffectChunkCallback} should be identical to their readr
counterparts, but have been copied into hipread to ensure that they
work even if readr changes.
\item The callback \code{HipDataFrameCallback} is similar to
readr::DataFrameCallback() except that it uses \code{dplyr::bind_rows()}
instead of \code{rbind()} so that it is faster.
}
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ChunkCallback$new()}}
\item \href{#method-receive}{\code{ChunkCallback$receive()}}
\item \href{#method-continue}{\code{ChunkCallback$continue()}}
\item \href{#method-result}{\code{ChunkCallback$result()}}
\item \href{#method-finally}{\code{ChunkCallback$finally()}}
\item \href{#method-clone}{\code{ChunkCallback$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-continue"></a>}}
\if{latex}{\out{\hypertarget{method-continue}{}}}
\subsection{Method \code{continue()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$continue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-result"></a>}}
\if{latex}{\out{\hypertarget{method-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finally"></a>}}
\if{latex}{\out{\hypertarget{method-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChunkCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super class}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{HipChunkCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-clone}{\code{HipChunkCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue">}\href{../../hipread/html/ChunkCallback.html#method-continue}{\code{hipread::ChunkCallback$continue()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="finally">}\href{../../hipread/html/ChunkCallback.html#method-finally}{\code{hipread::ChunkCallback$finally()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="initialize">}\href{../../hipread/html/ChunkCallback.html#method-initialize}{\code{hipread::ChunkCallback$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="receive">}\href{../../hipread/html/ChunkCallback.html#method-receive}{\code{hipread::ChunkCallback$receive()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="result">}\href{../../hipread/html/ChunkCallback.html#method-result}{\code{hipread::ChunkCallback$result()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipChunkCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{HipSideEffectChunkCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{HipSideEffectChunkCallback$new()}}
\item \href{#method-receive}{\code{HipSideEffectChunkCallback$receive()}}
\item \href{#method-continue}{\code{HipSideEffectChunkCallback$continue()}}
\item \href{#method-clone}{\code{HipSideEffectChunkCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="finally">}\href{../../hipread/html/ChunkCallback.html#method-finally}{\code{hipread::ChunkCallback$finally()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="result">}\href{../../hipread/html/ChunkCallback.html#method-result}{\code{hipread::ChunkCallback$result()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipSideEffectChunkCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipSideEffectChunkCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-continue"></a>}}
\if{latex}{\out{\hypertarget{method-continue}{}}}
\subsection{Method \code{continue()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipSideEffectChunkCallback$continue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipSideEffectChunkCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{HipListCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{HipListCallback$new()}}
\item \href{#method-receive}{\code{HipListCallback$receive()}}
\item \href{#method-result}{\code{HipListCallback$result()}}
\item \href{#method-finally}{\code{HipListCallback$finally()}}
\item \href{#method-clone}{\code{HipListCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue">}\href{../../hipread/html/ChunkCallback.html#method-continue}{\code{hipread::ChunkCallback$continue()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipListCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipListCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-result"></a>}}
\if{latex}{\out{\hypertarget{method-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipListCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finally"></a>}}
\if{latex}{\out{\hypertarget{method-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipListCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipListCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{HipDataFrameCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{HipDataFrameCallback$new()}}
\item \href{#method-receive}{\code{HipDataFrameCallback$receive()}}
\item \href{#method-result}{\code{HipDataFrameCallback$result()}}
\item \href{#method-finally}{\code{HipDataFrameCallback$finally()}}
\item \href{#method-clone}{\code{HipDataFrameCallback$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue">}\href{../../hipread/html/ChunkCallback.html#method-continue}{\code{hipread::ChunkCallback$continue()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipDataFrameCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipDataFrameCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-result"></a>}}
\if{latex}{\out{\hypertarget{method-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipDataFrameCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finally"></a>}}
\if{latex}{\out{\hypertarget{method-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipDataFrameCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HipDataFrameCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
