% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_AP2}
\alias{make_AP2}
\title{Make airport-pair dataset}
\usage{
make_AP2(adep, ades, ap = make_airports())
}
\arguments{
\item{adep, ades}{Identical-length lists of airport codes}

\item{ap}{List of locations of airports, defaults to the output
of \code{\link{make_airports}}.}
}
\value{
Dataframe with additional variables as described above.
}
\description{
\code{make_AP2} creates an airport-pair set from two sets of airports
}
\details{
This function takes two lists of airports (of the same length), specified
as 4-letter codes and combines them, adding the fields:

\itemize{
  \item \code{from_long, from_lat, to_long, to_lat}: the airport lat-longs
   with adep first
  \item \code{AP2}: a name for the route in a specific order
  \item \code{gcdist_km}: the great circle distance in km
}

In \code{AP2} European airports (crudely, from starting letter = 'E' or 'L')
are listed first, otherwise in alphabetical order. If unidirectional is TRUE,
then ">" is the separator, otherwise "<>".
(Unidirectional not currently supported)

For more details see the \href{../doc/Supersonic_Routes.html}{introductory vignette}.
}
\examples{

airports <- make_airports() #get a default set of lat-longs
ap2 <- make_AP2("NZAA","NZCH", airports)

}
