% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{makeOHLCV}
\alias{makeOHLCV}
\title{Make Open-High-Low-Close-Volume bars}
\usage{
makeOHLCV(pData, alignBy = "minutes", alignPeriod = 5, tz = NULL)
}
\arguments{
\item{pData}{\code{data.table} or \code{xts} object to make the bars out of, 
containing the intraday price series of possibly multiple stocks for possibly multiple days.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. 
Possible values are: \code{"secs"}, \code{"seconds"}, \code{"mins"}, \code{"minutes"}, \code{"hours"}, and \code{"ticks"}.
To aggregate based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to \code{"minutes"}.}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. For example, to aggregate
based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to \code{"minutes"}.}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. 
With the non-disk functionality, we attempt to extract the timezone from the DT column (or index) of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}.}
}
\description{
This function makes OHLC-V bars at arbitrary intervals. If the SIZE column is not present in the input, no volume column is created.
}
\examples{
\dontrun{
minuteBars <- makeOHLCV(sampleTDataEurope, alignBy = "minutes", alignPeriod = 1)
# We can use the quantmod package's chartSeries function to plot the ohlcv data
quantmod::chartSeries(minuteBars)

minuteBars <- makeOHLCV(sampleTDataEurope[,], alignBy = "minutes", alignPeriod = 1)
# Again we plot the series with chartSeries
quantmod::chartSeries(minuteBars)

# We can also handle data across multiple days.
fiveMinuteBars <- makeOHLCV(sampleTData)
# Again we plot the series with chartSeries
quantmod::chartSeries(fiveMinuteBars)

# We can use arbitrary alignPeriod, here we choose pi
bars <- makeOHLCV(sampleTDataEurope, alignBy = "seconds", alignPeriod = pi)
# Again we plot the series with chartSeries
quantmod::chartSeries(bars)
}
}
\author{
Emil Sjoerup
}
