% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{aggregatePrice}
\alias{aggregatePrice}
\title{Aggregate a time series but keep first and last observation}
\usage{
aggregatePrice(pdata, on = "minutes", k = 1, marketopen = "09:30:00",
  marketclose = "16:00:00", fill = FALSE, tz = NULL)
}
\arguments{
\item{pdata}{data.table or xts object to be aggregated containing the intraday price series, possibly across multiple days.}

\item{on}{character, indicating the time scale in which "k" is expressed. Possible values are: "milliseconds", "secs", "seconds", "mins", "minutes","hours".}

\item{k}{positive integer, indicating the number of periods to aggregate over; e.g. to aggregate a 
xts object to the 5 minute frequency set k = 5 and on = "minutes".}

\item{marketopen}{the market opening time, by default: marketopen = "09:30:00".}

\item{marketclose}{the market closing time, by default: marketclose = "16:00:00".}

\item{fill}{indicates whether rows without trades should be added with the most recent value, FALSE by default.}

\item{tz}{time zone used, by default: tz = timezone of DT column/index of xts.}
}
\value{
A data.table or xts object containing the aggregated time series.
}
\description{
Function returns new time series as xts object where first observation is always the opening price
and subsequent observations are the closing prices over the interval with as endpoint the timestamp 
of the result.
}
\details{
The timestamps of the new time series are the closing times and/or days of the intervals. 

In case of previous tick aggregation or on = "seconds"/"minutes"/"hours",
the element of the returned series with e.g. timestamp 09:35:00 contains 
the last observation up to that point, including the value at 09:35:00 itself.
}
\examples{
# aggregate price data to the 30 second frequency
aggregatePrice(sample_tdata_microseconds, on = "secs", k = 30)
# aggregate price data to the 30 second frequency including zero return price changes
aggregatePrice(sample_tdata_microseconds, on = "secs", k = 30)

# aggregate price data to half a second frequency including zero return price changes
aggregatePrice(sample_tdata_microseconds, on = "milliseconds", k = 500, fill = TRUE)
}
\author{
Jonathan Cornelissen, Kris Boudt and Onno Kleen.
}
\keyword{data}
\keyword{internal}
\keyword{manipulation}
