% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_symbol.R
\name{filter_by_keyword}
\alias{filter_by_keyword}
\title{Filter genes by keyword}
\usage{
filter_by_keyword(
  tbl,
  keyword,
  cols = c("symbol", "name", "alias_symbol", "alias_name", "prev_symbol", "prev_name")
)
}
\arguments{
\item{tbl}{A tibble containing the HGNC data set, typically obtained with `import_hgnc_dataset()`.}

\item{keyword}{A keyword or a regular expression to be used as search criterion.}

\item{cols}{Columns to be looked up.}
}
\value{
A [tibble][tibble::tibble-package] of the HGNC data set filtered by
  observations matching the `keyword`.
}
\description{
Filter the HGNC data set by a keyword to be looked up in the columns
containing gene names or symbols. By default, it will look up in `symbol`,
`name`, `alias_symbol`, `alias_name`, `prev_symbol` and `prev_name`. Note
that this function in dive into list-columns and match return a hit result if
at least one of the strings matches the `keyword`.
}
