% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather.R
\name{search_repo_logo}
\alias{search_repo_logo}
\title{Searches a given github repo URL for the best hex logo image.}
\usage{
search_repo_logo(
  pkg_name,
  repository,
  token = Sys.getenv("github_pat"),
  logo_patterns = getOption("hexFinder.logo_patterns"),
  ignore_patterns = getOption("hexFinder.ignore_patterns")
)
}
\arguments{
\item{pkg_name}{The mane of the package we want the logo for.}

\item{repository}{The github repository to search in.}

\item{token}{A github personal access token.
variable github_pat. If that variable is not set, you might run into API
limits when running too many queries.}

\item{logo_patterns}{String of valid name.extension file names for files to
look for, separated by |. {pkg_name} Can be used as a placeholder for
the package name.}

\item{ignore_patterns}{String of patterns to ignore when looking for a valid
logo. Can be part of the filename or part of the file path.}
}
\value{
A URL to a image or NULL if no image was found
}
\description{
Searches a given github repo URL for the best hex logo image.
}
\keyword{gather}
\keyword{internal}
