% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetGP.R, R/hetTP.R
\name{rebuild}
\alias{rebuild}
\alias{rebuild.homGP}
\alias{strip}
\alias{rebuild.hetGP}
\alias{rebuild.homTP}
\alias{rebuild.hetTP}
\title{Import and export of hetGP objects}
\usage{
rebuild(object, robust)

\method{rebuild}{homGP}(object, robust = FALSE)

strip(object)

\method{rebuild}{hetGP}(object, robust = FALSE)

\method{rebuild}{homTP}(object, robust = FALSE)

\method{rebuild}{hetTP}(object, robust = FALSE)
}
\arguments{
\item{object}{\code{homGP} or \code{homTP} model without slot \code{Ki} (inverse covariance matrix),
or \code{hetGP} or \code{hetTP} model without slot \code{Ki} or \code{Kgi}}

\item{robust}{if \code{TRUE} \code{\link[MASS]{ginv}} is used for matrix inversion, otherwise it is done via Cholesky.}
}
\value{
\code{object} with additional or removed slots.
}
\description{
Functions to make \code{hetGP} objects lighter before exporting them, and to reverse this after import.
The \code{rebuild} function may also be used to obtain more robust inverse of covariance matrices using \code{\link[MASS]{ginv}}.
}
\examples{
set.seed(32)
## motorcycle data
library(MASS)
X <- matrix(mcycle$times, ncol = 1)
Z <- mcycle$accel
## Model fitting
model <- mleHetGP(X = X, Z = Z, lower = 0.1, upper = 50)

# Check size
object.size(model)

# Remove internal elements, e.g., to save it
model <- strip(model)

# Check new size
object.size(model)

# Now rebuild model, and use ginv instead
model <- rebuild(model, robust = TRUE)
object.size(model)

}
