% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hesim_data.R
\name{id_attributes}
\alias{id_attributes}
\title{Attributes for ID variables}
\usage{
id_attributes(
  strategy_id,
  n_strategies,
  patient_id,
  n_patients,
  state_id = NULL,
  n_states = NULL,
  transition_id = NULL,
  n_transitions = NULL,
  time_id = NULL,
  time_intervals = NULL,
  n_times = NULL,
  sample = NULL,
  n_samples = NULL,
  grp_id = NULL,
  patient_wt = NULL
)
}
\arguments{
\item{strategy_id}{A numeric vector of integers denoting the treatment strategy.}

\item{n_strategies}{A scalar denoting the number of unique treatment strategies.}

\item{patient_id}{A numeric vector of integers denoting the patient.}

\item{n_patients}{A scalar denoting the number of unique patients.}

\item{state_id}{A numeric vector of integers denoting the health state.}

\item{n_states}{A scalar denoting the number of unique health states.}

\item{transition_id}{A numeric vector denoting the
health state transition. This is only used for state transition models.}

\item{n_transitions}{A scalar denoting the number of unique transitions.}

\item{time_id}{A numeric vector of integers denoting a unique time interval.}

\item{time_intervals}{A \code{data.table} denoting unique time intervals. Must
contain the columns \code{time_id}, \code{time_start}, and \code{time_stop}.
\code{time_start} is the starting time of an interval and \code{time_stop} is
the stopping time of an interval. Following the \link[survival:tmerge]{survival} package,
time intervals are closed on the right and
open on the left (except in the final interval where \code{time_stop} is equal to
infinity).}

\item{n_times}{A scalar denoting the number of time intervals. Equal to the
number of rows in \code{time_intervals}.}

\item{sample}{A numeric vector of integer denoting the sample from the posterior
distribution of the parameters.}

\item{n_samples}{A scalar denoting the number of samples.}

\item{grp_id}{An optional numeric vector of integers denoting the subgroup.}

\item{patient_wt}{An optional numeric vector denoting the weight to apply to each patient
within a subgroup.}
}
\description{
Stores metadata related to the ID variables used to index \link{input_mats}
and \link[=tparams]{transformed parameter objects} already predicted from covariates.
}
\details{
When using the ID variables to index \link{input_mats}, sorting order should be
the same as specified in \code{\link[=expand.hesim_data]{expand.hesim_data()}}; that is,
observations must be sorted by: (i) \code{strategy_id}, (ii) \code{patient_id},
and (iii) the health-related ID variable (either \code{state_id} or
\code{transition_id}). When using ID variables to index transformed parameter
objects and \code{sample} is used for indexing, then observations must be sorted by:
(i) \code{sample}, (ii) \code{strategy_id}, (iii) \code{patient_id}, and
(iv) the health-related ID variable.
}
\seealso{
\code{\link[=hesim_data]{hesim_data()}},\code{\link[=expand.hesim_data]{expand.hesim_data()}}, \link{input_mats}
}
