% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hesim_data.R
\name{expand.hesim_data}
\alias{expand.hesim_data}
\title{Expand hesim_data}
\usage{
\method{expand}{hesim_data}(object, by = c("strategies", "patients"), times = NULL)
}
\arguments{
\item{object}{An object of class \code{hesim_data}.}

\item{by}{A character vector of the names of the data tables in \code{hesim_data} to expand by.}

\item{times}{Either a numeric vector of distinct times denoting the start of time intervals or
q \link{time_intervals} object.}
}
\value{
An object of class \code{expanded_hesim_data}, which is a \code{data.table} with an "id_vars"
attribute containing the names of the ID variables in the data table and, if \code{times} is
not \code{NULL}, a \code{time_intervals} object derived from \code{times}.
}
\description{
Create a data table in long format from all combinations of specified tables
from an object of class \link{hesim_data} and optionally time intervals. See "Details" for
an explanation of how the expansion is done.
}
\details{
This function is similar to \code{\link[=expand.grid]{expand.grid()}}, but works for data frames or data tables.
Specifically, it creates a \code{data.table} from all combinations of the supplied tables in \code{object}
and optionally the start of times intervals in \code{times}.
The supplied tables are determined using the \code{by} argument. The resulting dataset is sorted by
prioritizing ID variables as follows: (i) \code{strategy_id}, (ii) \code{patient_id},
(iii) the health-related ID variable (either \code{state_id} or \code{transition_id}, and
(iv) the time intervals from \code{times}.
}
\examples{
strategies <- data.frame(strategy_id = c(1, 2))
patients <- data.frame(patient_id = seq(1, 3), age = c(65, 50, 75),
                          gender = c("Female", "Female", "Male"))
states <- data.frame(state_id =  seq(1, 3),
                     state_var = c(2, 1, 9))
hesim_dat <- hesim_data(strategies = strategies,
                        patients = patients,
                        states = states)
expand(hesim_dat, by = c("strategies", "patients"))
expand(hesim_dat, by = c("strategies", "patients"),
       times = c(0, 2, 10))
}
