% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kronecker.seq.R
\name{kronecker.seq}
\alias{kronecker.seq}
\alias{kronecker_seq}
\alias{kroneckerSeq}
\alias{KroneckerSeq}
\title{A sequence of kronecker products}
\usage{
kronecker.seq(X, FUN = "*", make.dimnames = FALSE, ...)

kronecker_seq(X, FUN = "*", make.dimnames = FALSE, ...)

kroneckerSeq(X, FUN = "*", make.dimnames = FALSE, ...)

KroneckerSeq(X, FUN = "*", make.dimnames = FALSE, ...)
}
\arguments{
\item{X}{A list of numeric matrices or arrays}

\item{FUN}{a function; it may be a quoted string.}

\item{make.dimnames}{Provide dimnames that are the product of the
   dimnames of \code{X} and \code{Y}.}

\item{...}{optional arguments to be passed to \code{FUN}.}
}
\value{
A matrix or array
}
\description{
A sequence of kronecker products
}
\examples{
x1 = matrix(rnorm(16), nrow = 4)
x2 = matrix(rnorm(25), nrow = 5)
x3 = matrix(rnorm(36), nrow = 6)
x4 = matrix(rnorm(49), nrow = 7)
p1 = x1 \%x\% x2 \%x\% x3 \%x\% x4
p2 = kronecker.seq(list(x1, x2, x3, x4))
all.equal(p1, p2)
}
