% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScore.R
\name{plotScore}
\alias{plotScore}
\title{Plot Healthy Eating Index (HEI) scores from NHANES data}
\usage{
plotScore(
  graph = NULL,
  scoringMethod,
  years,
  heiComponent,
  demographicGroup = NULL,
  sex = c("Female", "Male"),
  raceEthnicity = c("Asian", "White", "Black", "Other", "Mexican American",
    "Other Hispanic"),
  age = c(2, 100),
  familyIncome = c("[0, 5000)", "[5000, 10000)", "[10000, 15000)", "[15000, 20000)",
    "[20000, 25000)", "[25000, 35000)", "[35000, 45000)", "[45000, 55000)",
    "[55000, 65000)", "[65000, 75000)", "75000+", "[75000, 100000)", ">100000", ">20000",
    "<20000", "Refused", "Don't know", "NA")
)
}
\arguments{
\item{graph}{The desired graph type. Choose "Histogram" when scoringMethod = "Simple". Choose "Bar" when scoringMethod = "Pop Ratio" or "Mean Ratio" and heiComponent is not "Total Score". Choose "Bar" or "Radar" when scoringMethod = "Pop Ratio" or "Mean Ratio" and heiComponent = "Total Score"}

\item{scoringMethod}{The HEI scoring method to use. Choose from "Simple," "Pop Ratio," or "Mean Ratio."}

\item{years}{The NHANES cycle to select, choose from: "0506," "0708," "0910," "1112," "1314," "1516," or "1718. etc.}

\item{heiComponent}{The HEI component to score and plot. Options include "Total Score", "Total Fruit", "Whole Fruits", "Total Vegetables", "Greens and Beans", "Whole Grains", "Total Dairy", "Total Protein", "Seafood and Plant Proteins", "Fatty Acids", "Refined Grains", "Sodium", "Added Sugars", and "Saturated Fat".}

\item{demographicGroup}{The demographic grouping by which the data should be scored. If scoringMethod = "Simple", choose NULL as the demographicGroup. Otherwise, choose from "Sex", "Race/Ethnicity", "Age", or "Family Income".}

\item{sex}{a vector of the sexes in desired subpopulation. Provide a vector with "Female", "Male", or both.}

\item{raceEthnicity}{a vector of races/ethnicities in desired subpopulation. Provide a vector including any combination of the following: "Asian", "White", "Black", "Other", "Mexican American", "Other Hispanic",}

\item{age}{a vector in the form c(min, max) with two numbers specifying the desired age range to analyze. Both numbers should either be between 0 and 1 or 2 and above.}

\item{familyIncome}{a vector of family income brackets in the desired subpopulation. Provide a vector including any combination of the following: "[0, 5000)","[5000, 10000)","[10000, 15000)","[15000, 20000)","[20000, 25000)","[25000, 35000)", "[35000, 45000)","[45000, 55000)","[55000, 65000)","[65000, 75000)","[75000, 100000)", "75000+",">100000", ">20000","<20000","Refused","Don't know", "NA"}
}
\value{
A base R plot or a ggplot object with the specified plot
}
\description{
This function plots HEI component or total scores using the inputted scoring method and graph type. The user can subset the data to only include subjects in specific demographic groups
}
\examples{
library(ggplot2)
library(grDevices)
library(RColorBrewer)
library(rlang)
library(magrittr)
library(dplyr)
library(tibble)
library(rlang)
library(stats)
library(tidyr)

# Plot the Total Dairy component score from the 2005-06 NHANES data using the
# "Simple" method.

dairy_plot <- plotScore(graph = "Histogram",
                        scoringMethod = "Simple",
                        years = "0506",
                        heiComponent = "Total Dairy")
dairy_plot

# Create a radar plot to display the total HEI score by race/ethnicity using
# the mean ratio method for subjects that are male, more than 50 years old,
# with a family income in the range [65000, 75000) for the 2015-16 NHANES
# cycle.
radar_example_plot <- plotScore(graph = "Radar",
                    scoringMethod = "Mean Ratio",
                    years = "1516",
                    heiComponent = "Total Score",
                    demographicGroup = "Race/Ethnicity",
                    sex = "Male",
                    age = c(50, 150),
                    familyIncome = "[65000, 75000)")
radar_example_plot

}
