% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resamp_define.R
\name{define_psa}
\alias{define_psa}
\alias{define_psa_}
\title{Define Parameters Distribution for Probabilistic Analysis}
\usage{
define_psa(..., correlation)

define_psa_(.dots = list(), correlation)
}
\arguments{
\item{...}{Formulas defining parameter distributions.}

\item{correlation}{A correlation matrix for parameters or
the output of \code{\link[=define_correlation]{define_correlation()}}.}

\item{.dots}{Pair/values of expressions coercible to quosures.}
}
\value{
An object of class \code{resamp_definition}.
Contains \code{list_qdist}, a list of quantile
functions and \code{correlation} a correlation matrix.
}
\description{
Define the properties of parameter distributions and
their correlation structure for probabilistic uncertainty
analysis of Markov models.
}
\details{
The distributions must be defined within \code{heemod}
(see \link{distributions}), or defined with
\code{\link[=define_distribution]{define_distribution()}}.

If no correlation matrix is specified parameters are
assumed to be independant.

The correlation matrix need only be specified for
correlated parameters.
}
\examples{
mc <- define_correlation(
  age_init, cost_init, .4
)

define_psa(
    age_init ~ normal(60, 10),
    cost_init ~ normal(1000, 100),
    correlation = mc
)

# example with multinomial parameters

define_psa(
  rate1 + rate2 + rate3 ~ multinomial(10, 50, 40),
  a + b ~ multinomial(15, 30)
)
}
