% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_tbl_functions.R
\name{category_counts_tbl}
\alias{category_counts_tbl}
\title{Counts by Category}
\usage{
category_counts_tbl(.data, .count_col, .arrange_value = TRUE, ...)
}
\arguments{
\item{.data}{The data.frame/tibble supplied.}

\item{.count_col}{The column that has the values you want to count.}

\item{.arrange_value}{Defaults to true, this will arrange the resulting tibble
in descending order by .count_col}

\item{...}{Place the values you want to pass in for grouping here.}
}
\description{
Get the counts of a column by a particular grouping if supplied, otherwise just
get counts of a column.
}
\details{
\itemize{
\item Requires a data.frame/tibble.
\item Requires a value column, a column that is going to counted.
}
}
\examples{
library(healthyR.data)
library(dplyr)

healthyR_data \%>\%
  category_counts_tbl(
    .count_col = payer_grouping
    , .arrange = TRUE
    , ip_op_flag
  )

healthyR_data \%>\%
  category_counts_tbl(
    .count_col = ip_op_flag
    , .arrange_value = TRUE
    , service_line
  )

}
\author{
Steven P. Sanderson II, MPH
}
