% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-singlediff-stationary.R
\name{util_singlediff_ts}
\alias{util_singlediff_ts}
\title{Single Differencing to Make Time Series Stationary}
\usage{
util_singlediff_ts(.time_series)
}
\arguments{
\item{.time_series}{A time series object to be made stationary.}
}
\value{
If the time series is already stationary or the single differencing is successful,
it returns a list as described in the details section. If additional differencing is required,
it informs the user and returns a list with ret set to FALSE.
}
\description{
This function attempts to make a non-stationary time series stationary by applying
single differencing. It iteratively increases the differencing order until stationarity is achieved.
}
\details{
The function calculates the frequency of the input time series using the \code{stats::frequency} function.
It then applies single differencing incrementally until the Augmented Dickey-Fuller test indicates
stationarity (p-value < 0.05) or until the differencing order reaches the frequency of the data.

If single differencing successfully makes the time series stationary, it returns the stationary time series
and related information as a list with the following elements:
\itemize{
\item stationary_ts: The stationary time series after differencing.
\item ndiffs: The order of differencing applied to make it stationary.
\item adf_stats: Augmented Dickey-Fuller test statistics on the stationary time series.
\item trans_type: Transformation type, which is "diff" in this case.
\item ret: TRUE to indicate a successful transformation.
}

If the data requires more single differencing than its frequency allows, it informs the user and
returns a list with ret set to FALSE, indicating that double differencing may be needed.
}
\examples{
# Example 1: Using a time series dataset
util_singlediff_ts(AirPassengers)

# Example 2: Using a different time series dataset
util_singlediff_ts(BJsales)$ret

}
\seealso{
Other Utility: 
\code{\link{auto_stationarize}()},
\code{\link{calibrate_and_plot}()},
\code{\link{internal_ts_backward_event_tbl}()},
\code{\link{internal_ts_both_event_tbl}()},
\code{\link{internal_ts_forward_event_tbl}()},
\code{\link{model_extraction_helper}()},
\code{\link{ts_get_date_columns}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_is_date_class}()},
\code{\link{ts_lag_correlation}()},
\code{\link{ts_model_auto_tune}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_model_spec_tune_template}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()},
\code{\link{ts_to_tbl}()},
\code{\link{util_difflog_ts}()},
\code{\link{util_doublediff_ts}()},
\code{\link{util_doubledifflog_ts}()},
\code{\link{util_log_ts}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
