% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-doubledifflog-stationary.R
\name{util_doubledifflog_ts}
\alias{util_doubledifflog_ts}
\title{Double Differencing with Log Transformation to Make Time Series Stationary}
\usage{
util_doubledifflog_ts(.time_series)
}
\arguments{
\item{.time_series}{A time series object to be made stationary.}
}
\value{
If the time series is already stationary or the double differencing with a logarithmic transformation is successful,
it returns a list as described in the details section. If the transformation is not possible, it informs
the user and returns a list with ret set to FALSE, indicating that the data could not be stationarized.
}
\description{
This function attempts to make a non-stationary time series stationary by applying
double differencing with a logarithmic transformation. It iteratively increases the differencing order
until stationarity is achieved or informs the user if the transformation is not possible.
}
\details{
The function calculates the frequency of the input time series using the \code{stats::frequency} function
and checks if the minimum value of the time series is greater than 0. It then applies double differencing
with a logarithmic transformation incrementally until the Augmented Dickey-Fuller test indicates
stationarity (p-value < 0.05) or until the differencing order reaches the frequency of the data.

If double differencing with a logarithmic transformation successfully makes the time series stationary,
it returns the stationary time series and related information as a list with the following elements:
\itemize{
\item stationary_ts: The stationary time series after the transformation.
\item ndiffs: The order of differencing applied to make it stationary.
\item adf_stats: Augmented Dickey-Fuller test statistics on the stationary time series.
\item trans_type: Transformation type, which is "double_diff_log" in this case.
\item ret: TRUE to indicate a successful transformation.
}

If the data either had a minimum value less than or equal to 0 or requires more differencing than
its frequency allows, it informs the user that the data could not be stationarized.
}
\examples{
# Example 1: Using a time series dataset
util_doubledifflog_ts(AirPassengers)

# Example 2: Using a different time series dataset
util_doubledifflog_ts(BJsales)$ret

}
\seealso{
Other Utility: 
\code{\link{auto_stationarize}()},
\code{\link{calibrate_and_plot}()},
\code{\link{internal_ts_backward_event_tbl}()},
\code{\link{internal_ts_both_event_tbl}()},
\code{\link{internal_ts_forward_event_tbl}()},
\code{\link{model_extraction_helper}()},
\code{\link{ts_get_date_columns}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_is_date_class}()},
\code{\link{ts_lag_correlation}()},
\code{\link{ts_model_auto_tune}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_model_spec_tune_template}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()},
\code{\link{ts_to_tbl}()},
\code{\link{util_difflog_ts}()},
\code{\link{util_doublediff_ts}()},
\code{\link{util_log_ts}()},
\code{\link{util_singlediff_ts}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
