% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-ts-velocity.R
\name{ts_velocity_vec}
\alias{ts_velocity_vec}
\title{Vector Function Time Series Acceleration}
\usage{
ts_velocity_vec(.x)
}
\arguments{
\item{.x}{A numeric vector}
}
\value{
A numeric vector
}
\description{
Takes a numeric vector and will return the velocity of that vector.
}
\details{
Takes a numeric vector and will return the velocity of that vector. The
velocity of a time series is computed by taking the first difference, so
\deqn{x_t - x_t1}

This function can be used on it's own. It is also the basis for the function
\code{\link[=ts_velocity_augment]{ts_velocity_augment()}}.
}
\examples{
suppressPackageStartupMessages(library(dplyr))

len_out    = 25
by_unit    = "month"
start_date = as.Date("2021-01-01")

data_tbl <- tibble(
  date_col = seq.Date(from = start_date, length.out = len_out, by = by_unit),
  a    = rnorm(len_out),
  b    = runif(len_out)
)

vec_1 <- ts_velocity_vec(data_tbl$b)

plot(data_tbl$b)
lines(data_tbl$b)
lines(vec_1, col = "blue")

}
\seealso{
Other Vector Function: 
\code{\link{ts_acceleration_vec}()},
\code{\link{ts_growth_rate_vec}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Vector Function}
