% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs-xgboost-reg.R
\name{ts_wfs_xgboost}
\alias{ts_wfs_xgboost}
\title{Auto XGBoost (XGBoost) Workflowset Function}
\usage{
ts_wfs_xgboost(
  .model_type = "xgboost",
  .recipe_list,
  .trees = 15L,
  .min_n = 1L,
  .tree_depth = 6L,
  .learn_rate = 0.3,
  .loss_reduction = 0,
  .sample_size = 1,
  .stop_iter = Inf
)
}
\arguments{
\item{.model_type}{This is where you will set your engine. It uses
\link[parsnip:boost_tree]{parsnip::boost_tree} under the hood and can take one of the following:
\itemize{
\item "xgboost"
}}

\item{.recipe_list}{You must supply a list of recipes. list(rec_1, rec_2, ...)}

\item{.trees}{The number of trees (type: integer, default: 15L)}

\item{.min_n}{Minimal Node Size (type: integer, default: 1L)}

\item{.tree_depth}{Tree Depth (type: integer, default: 6L)}

\item{.learn_rate}{Learning Rate (type: double, default: 0.3)}

\item{.loss_reduction}{Minimum Loss Reduction (type: double, default: 0.0)}

\item{.sample_size}{Proportion Observations Sampled (type: double, default: 1.0)}

\item{.stop_iter}{The number of ierations Before Stopping (type: integer, default: Inf)}
}
\value{
Returns a workflowsets object.
}
\description{
This function is used to quickly create a workflowsets object.
}
\details{
This function expects to take in the recipes that you want to use in
the modeling process. This is an automated workflow process. There are sensible
defaults set for the model specification, but if you choose you can set them
yourself if you have a good understanding of what they should be. The mode is
set to "regression".

This only uses the option \code{set_engine("xgboost")} and therefore the .model_type
is not needed. The parameter is kept because it is possible in the future that
this could change, and it keeps with the framework of how other functions
are written.

\code{\link[parsnip:boost_tree]{parsnip::boost_tree()}} xgboost::xgb.train() creates a series of decision trees
forming an ensemble. Each tree depends on the results of previous trees.
All trees in the ensemble are combined to produce a final prediction.
}
\examples{
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(rsample))

data <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

splits <- time_series_split(
   data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

rec_objs <- ts_auto_recipe(
 .data = training(splits)
 , .date_col = date_col
 , .pred_col = value
)

wf_sets <- ts_wfs_xgboost("xgboost", rec_objs)
wf_sets

}
\seealso{
\url{https://workflowsets.tidymodels.org/}

\url{https://parsnip.tidymodels.org/reference/details_boost_tree_xgboost.html}

\url{https://arxiv.org/abs/1603.02754}

Other Auto Workflowsets: 
\code{\link{ts_wfs_arima_boost}()},
\code{\link{ts_wfs_auto_arima}()},
\code{\link{ts_wfs_ets_reg}()},
\code{\link{ts_wfs_lin_reg}()},
\code{\link{ts_wfs_mars}()},
\code{\link{ts_wfs_nnetar_reg}()},
\code{\link{ts_wfs_prophet_reg}()},
\code{\link{ts_wfs_svm_poly}()},
\code{\link{ts_wfs_svm_rbf}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Auto Workflowsets}
