% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs-nnetar-reg.R
\name{ts_wfs_nnetar_reg}
\alias{ts_wfs_nnetar_reg}
\title{Auto NNETAR Workflowset Function}
\usage{
ts_wfs_nnetar_reg(
  .model_type = "nnetar",
  .recipe_list,
  .non_seasonal_ar = 0,
  .seasonal_ar = 0,
  .hidden_units = 5,
  .num_networks = 10,
  .penalty = 0.1,
  .epochs = 10
)
}
\arguments{
\item{.model_type}{This is where you will set your engine. It uses
\code{\link[modeltime:nnetar_reg]{modeltime::nnetar_reg()}} under the hood and can take one of the following:
\itemize{
\item "nnetar"
}}

\item{.recipe_list}{You must supply a list of recipes. list(rec_1, rec_2, ...)}

\item{.non_seasonal_ar}{The order of the non-seasonal auto-regressive (AR) terms.
Often denoted "p" in pdq-notation.}

\item{.seasonal_ar}{The order of the seasonal auto-regressive (SAR) terms.
Often denoted "P" in PDQ-notation.}

\item{.hidden_units}{An integer for the number of units in the hidden model.}

\item{.num_networks}{Number of networks to fit with different random starting
weights. These are then averaged when producing forecasts.}

\item{.penalty}{A non-negative numeric value for the amount of weight decay.}

\item{.epochs}{An integer for the number of training iterations.}
}
\value{
Returns a workflowsets object.
}
\description{
This function is used to quickly create a workflowsets object.
}
\details{
This function expects to take in the recipes that you want to use in
the modeling process. This is an automated workflow process. There are sensible
defaults set for the model specification, but if you choose you can set them
yourself if you have a good understanding of what they should be. The mode is
set to "regression".

This uses the following engines:

\code{\link[modeltime:nnetar_reg]{modeltime::nnetar_reg()}} nnetar_reg() is a way to generate a specification
of an NNETAR model before fitting and allows the model to be created using
different packages. Currently the only package is forecast.
\itemize{
\item "nnetar"
}
}
\examples{
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(rsample))

data <- AirPassengers \%>\%
  ts_to_tbl() \%>\%
  select(-index)

splits <- time_series_split(
   data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

rec_objs <- ts_auto_recipe(
 .data = training(splits)
 , .date_col = date_col
 , .pred_col = value
)

wf_sets <- ts_wfs_nnetar_reg("nnetar", rec_objs)
wf_sets

}
\seealso{
\url{https://workflowsets.tidymodels.org/}

\url{https://business-science.github.io/modeltime/reference/nnetar_reg.html}

Other Auto Workflowsets: 
\code{\link{ts_wfs_arima_boost}()},
\code{\link{ts_wfs_auto_arima}()},
\code{\link{ts_wfs_ets_reg}()},
\code{\link{ts_wfs_lin_reg}()},
\code{\link{ts_wfs_mars}()},
\code{\link{ts_wfs_prophet_reg}()},
\code{\link{ts_wfs_svm_poly}()},
\code{\link{ts_wfs_svm_rbf}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Auto Workflowsets}
