% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spcma.R
\name{mediate_spcma}
\alias{mediate_spcma}
\title{Sparse Principal Component Mediation Analysis for High-Dimensional Mediators}
\source{
\url{https://rdrr.io/github/zhaoyi1026/spcma}
}
\usage{
mediate_spcma(
  A,
  M,
  Y,
  var_per = 0.8,
  n_pc = NULL,
  sims = 1000,
  boot_ci_type = "bca",
  ci_level = 0.95,
  fused = FALSE,
  gamma = 0,
  per_jump = 0.7,
  eps = 1e-04,
  maxsteps = 2000,
  seed = 1
)
}
\arguments{
\item{A}{length \code{n} numeric vector containing exposure variable}

\item{M}{\code{n x p} numeric matrix of high-dimensional mediators.}

\item{Y}{length \code{n} numeric vector containing continuous outcome variable.}

\item{var_per}{a numeric variable with the desired proportion of variance
explained. Default is 0.8.}

\item{n_pc}{optional numeric variable with the desired number of PCs, in which case
\code{var_per} is ignored. Default is \code{NULL} and the number of PCs is
determined based on the desired proportion of variance explained.}

\item{sims}{number of Monte Carlo draws for nonparametric bootstrap or
quasi-Bayesian approximation (see \code{\link[mediation:mediate]{mediation::mediate()}}).
Default is 1000.}

\item{boot_ci_type}{character string indicating the type of bootstrap
confidence intervals for when \code{boot = TRUE}. If \code{"bca"},
bias-corrected and accelerated (BCa) confidence intervals will be estimated.
If \code{"perc"}, percentile confidence intervals will be estimated
(see \code{\link[mediation:mediate]{mediation::mediate()}}). Default is "bca".}

\item{ci_level}{the designated confidence level. Default 0.95.}

\item{fused}{logical variable for whether the fused LASSO should be used
instead of the ordinary LASSO. Default is \code{FALSE}.}

\item{gamma}{numeric variable \code{>=0} indicating the ratio of the
standard LASSO penalty to the fusion penalty (see \code{\link[genlasso:genlasso]{genlasso::genlasso()}}).
Ignored if \code{fused = FALSE}. Default is 0, meaning there is no standard
penalty. Larger values result in more shrinkage and sparser PCs.}

\item{per_jump}{numeric value used for tuning parameter selection - the
quantile cut-off for total variance change under different \code{lambda} values
in the LASSO. Default is 0.7. Larger values result in more shrinkage and
sparser PCs}

\item{eps}{numeric variable indicating the multiplier for the ridge penalty
in case \code{X} is rank deficient (see  \code{\link[genlasso:genlasso]{genlasso::genlasso()}}).
Default is \code{1e-4}.}

\item{maxsteps}{an integer specifying the maximum number of steps for the
algorithm before termination (see \code{\link[genlasso:genlasso]{genlasso::genlasso()}}). Default
is 2000.}

\item{seed}{seed used for fitting single-mediator models after PCA}
}
\value{
A list containing:
\itemize{
\item{loadings: }{a matrix of the sparse PC loadings.}
\item{pcs: }{a matrix of the PCs.}
\item{var_explained: the cumulative proportion of variance explained by the PCs.}
\item{contributions: }{a data frame containing the estimates, confidence
intervals, and p-values of the mediation contributions.}
\item{effects: }{a data frame containing the estimated direct, global
mediation, and total effects}
}
}
\description{
\code{mediate_spcma} applies sparse principal component mediation
analysis to mediation settings in which the mediators are high-dimensional.
}
\details{
\code{mediate_spcma} performs principal component mediation analysis, comparable
to \code{mediate_pcma}, with the modification that the PC loadings are sparsified
by a flexible LASSO penalty. This has the potential make the PCs more interpretable,
since, unlike in PCA, they are only linear combinations of a subset of mediators
rather than all of them. The choice of LASSO penalties is determined by
the \code{fused} argument - which, when set to \code{TRUE}, deploys a fused
LASSO penalty that encourages the model to give consecutive mediators
similar loadings. The default is \code{fused = FALSE}, and the standard
LASSO penalty is used instead of the fusion penalty. Once the sparse PCs are
computed, inference proceeds exactly like in PCMA, and the PC-mediators are
evaluated with methods from the \code{mediate} package.
}
\examples{
A <- med_dat$A
M <- med_dat$M
Y <- med_dat$Y

# Fit SPCMA with the fused LASSO penalty while choosing the number of PCs based
# on the variance they explain. In practice, var_per and sims should be higher.
out <- mediate_spcma(A, M, Y, var_per = 0.25, fused = TRUE, gamma = 2, sims = 10)
out$effects

}
\references{
Zhao, Y., Lindquist, M. A. & Caffo, B. S. Sparse principal
component based high-dimensional mediation analysis. Comput. Stat.
Data Anal. 142, 106835 (2020).
}
