% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmu_lasso_binomial.R
\name{gmu_lasso_binomial}
\alias{gmu_lasso_binomial}
\title{Generalized Matrix Uncertainty Lasso}
\usage{
gmu_lasso_binomial(W, y, lambda = NULL, delta = NULL,
  activeSet = FALSE)
}
\arguments{
\item{W}{Design matrix, measured with error. Must be a numeric matrix.}

\item{y}{Vector of responses.}

\item{lambda}{Regularization parameter.}

\item{delta}{Additional regularization parameter, bounding the measurement
error.}

\item{activeSet}{Logical. Whether to use an active set strategy.}
}
\value{
Intercept and coefficients at the values of lambda and delta
  specified.
}
\description{
Generalized Matrix Uncertainty Lasso. This is a worker function
  for which an interface will be added later.
}
\references{
\insertRef{rosenbaum2010}{hdme} \insertRef{sorensen2018}{hdme}
}
