% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TRMM.R
\name{TRMM}
\alias{TRMM}
\title{Download and convert TRMM data}
\usage{
TRMM(inputLocation = "ftp://disc2.nascom.nasa.gov/data/TRMM/Gridded/",
  product = "3B43", version = 7, type = "precipitation.accum",
  timeExtent = NULL, bbox = NULL, outputfileLocation = NULL)
}
\arguments{
\item{inputLocation}{location where data is stored. By default it points to the TRMM ftp server ("ftp://disc2.nascom.nasa.gov/data/TRMM/Gridded/") but it can also be a local directory. If you are using a local directory, this function expects to find inside 'inputLocation' a folder with the name of product and version (e.g. "i3B43_V7") and inside this a folder for each year( e.g. "2012").}

\item{product}{this is the code that identifies a product, default is "3B43"}

\item{version}{this is the version number, default is 7}

\item{type}{this is the type of information needed, default is "precipitation.accum". Other types could be "gaugeRelativeWeighting.bin" and "relativeError.bin"}

\item{timeExtent}{is a vector of dates and times for which the data should be retrieve}

\item{bbox}{OPTIONAL bounding box, a list made of 4 elements: minimum longitude (lonMin), minimum latitude (latMin), maximum longitude (lonMax), maximum latitude (latMax)}

\item{outputfileLocation}{file path where to save the GeoTiff}
}
\value{
Data is loaded as rasterbrick, then converted to a multilayer Geotiff that can
}
\description{
The TRMM dataset provide global historical rainfall estimation in a gridded format.
}
\details{
This code is based upon Martin Brandt's blog post:
http://matinbrandt.wordpress.com/2013/09/04/automatically-downloading-and-processing-trmm-rainfall-data/
and on the TRMM FAQ: http://disc.sci.gsfc.nasa.gov/additional/faq/precipitation_faq.shtml
}
\examples{
\dontrun{
  # Define a bounding box
  bbox <- list(lonMin=-3.82, latMin=48,lonMax=-3.63, latMax=50)
  twindow <- seq(as.Date("2012-01-01"), as.Date("2012-01-31"), by="months")

  TRMM(inputLocation="ftp://disc2.nascom.nasa.gov/data/TRMM/Gridded/",
       product = "3B43",
       version = 7,
       type = "precipitation.accum",
       timeExtent = twindow,
       bbox = bbox,
       outputfileLocation = "~/")

  # or simply
  TRMM(timeExtent = twindow, bbox = bbox)#'
  plot(brick("~/trmm_acc.tif"))
}

}
\author{
Claudia Vitolo
}

