% Generated by roxygen2 (4.0.2): do not edit by hand
\name{KGClimateClass}
\alias{KGClimateClass}
\title{Function to identify the updated Koppen-Greiger climate zone (on a 0.1 x 0.1 degrees resolution map).}
\usage{
KGClimateClass(lonMin, lonMax, latMin, latMax, updatedBy = "Peel")
}
\arguments{
\item{lonMin}{Minimum latitude of bounding box}

\item{lonMax}{Maximum latitude of bounding box}

\item{latMin}{Minimum longitude of bounding box}

\item{latMax}{Maximum longitude of bounding box}

\item{updatedBy}{this can either be Kottek (http://koeppen-geiger.vu-wien.ac.at/) or Peel (http://people.eng.unimelb.edu.au/mpeel/koppen.html)}
}
\value{
List of overlapping climate zones.
}
\description{
Given a bounding box, the function identifies the overlapping climate zones.
}
\examples{
KGClimateClass(lonMin=-3.82,lonMax=-3.63,latMin=52.41,latMax=52.52,
               updatedBy="Peel")
KGClimateClass(lonMin=-3.82,lonMax=-3.63,latMin=52.41,latMax=52.52,
               updatedBy="Kottek")
}
\author{
Claudia Vitolo
}

