% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcWO_formula.R
\name{calcWO.formula}
\alias{calcWO.formula}
\title{Win odds calculation using formula syntax}
\usage{
\method{calcWO}{formula}(x, data, ...)
}
\arguments{
\item{x}{an object of class formula.}

\item{data}{a data frame.}

\item{...}{additional parameters.}
}
\value{
a data frame containing the win odds and its confidence interval. It contains the following columns:
\itemize{
\item WO calculated win odds.
\item LCL lower confidence limit.
\item UCL upper confidence limit.
\item SE standard error of the win odds.
\item WOnull win odds of the null hypothesis (specified in the \code{WOnull} argument).
\item alpha two-sided significance level for calculating the confidence interval (specified in the \code{alpha} argument).
\item Pvalue p-value associated with testing the null hypothesis.
\item WP calculated win probability.
\item LCL_WP lower confidence limit for \code{WP}.
\item UCL_WP upper confidence limit for \code{WP}.
\item SE_WP standard error of the win probability.
\item SD_WP standard deviation of the win probability, calculated as \code{SE_WP} multiplied by \code{sqrt(N)}.
\item N total number of patients in the analysis.
\item formula returning the specified formula in the \code{x} argument.
\item ref showing how the reference group was selected. Can be modifying by specifying the \code{ref} argument.
}
}
\description{
Win odds calculation using formula syntax
}
\examples{
#Example 1
data(HCE1)
calcWO(AVAL ~ TRTP, data = HCE1)

#Example 2
calcWO(data = COVID19, GROUP ~ TRTP, ref = "Placebo")

}
\references{
Gasparyan SB et al. "Adjusted win ratio with stratification: calculation methods and interpretation." Statistical Methods in Medical Research 30.2 (2021): 580-611. \url{doi:10.1177/0962280220942558}
}
\seealso{
\code{\link[=calcWO]{calcWO()}}, \code{\link[=calcWO.hce]{calcWO.hce()}}, \code{\link[=calcWO.data.frame]{calcWO.data.frame()}}.
}
