// Generated by rstantools.  Do not edit by hand.

/*
    hbamr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hbamr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hbamr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_HBAM_MINI_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_HBAM_MINI");
    reader.add_event(89, 87, "end", "model_HBAM_MINI");
    return reader;
}
#include <stan_meta_header.hpp>
class model_HBAM_MINI
  : public stan::model::model_base_crtp<model_HBAM_MINI> {
private:
        int N;
        int J;
        int N_obs;
        std::vector<int> ii;
        std::vector<int> jj;
        int B;
        int L;
        int R;
        std::vector<int> Y;
        vector_d V;
        int CV;
        std::vector<int> holdout;
        double sigma_alpha_prior_rate;
        double tau_prior_rate;
public:
    model_HBAM_MINI(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_HBAM_MINI(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_HBAM_MINI_namespace::model_HBAM_MINI";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            check_greater_or_equal(function__, "J", J, 1);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "N_obs", "int", context__.to_vec());
            N_obs = int(0);
            vals_i__ = context__.vals_i("N_obs");
            pos__ = 0;
            N_obs = vals_i__[pos__++];
            check_greater_or_equal(function__, "N_obs", N_obs, 1);
            current_statement_begin__ = 5;
            validate_non_negative_index("ii", "N_obs", N_obs);
            context__.validate_dims("data initialization", "ii", "int", context__.to_vec(N_obs));
            ii = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("ii");
            pos__ = 0;
            size_t ii_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < ii_k_0_max__; ++k_0__) {
                ii[k_0__] = vals_i__[pos__++];
            }
            size_t ii_i_0_max__ = N_obs;
            for (size_t i_0__ = 0; i_0__ < ii_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ii[i_0__]", ii[i_0__], 1);
            }
            current_statement_begin__ = 6;
            validate_non_negative_index("jj", "N_obs", N_obs);
            context__.validate_dims("data initialization", "jj", "int", context__.to_vec(N_obs));
            jj = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("jj");
            pos__ = 0;
            size_t jj_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < jj_k_0_max__; ++k_0__) {
                jj[k_0__] = vals_i__[pos__++];
            }
            size_t jj_i_0_max__ = N_obs;
            for (size_t i_0__ = 0; i_0__ < jj_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "jj[i_0__]", jj[i_0__], 1);
            }
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "B", "int", context__.to_vec());
            B = int(0);
            vals_i__ = context__.vals_i("B");
            pos__ = 0;
            B = vals_i__[pos__++];
            check_greater_or_equal(function__, "B", B, 1);
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "L", "int", context__.to_vec());
            L = int(0);
            vals_i__ = context__.vals_i("L");
            pos__ = 0;
            L = vals_i__[pos__++];
            check_greater_or_equal(function__, "L", L, 1);
            check_less_or_equal(function__, "L", L, J);
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "R", "int", context__.to_vec());
            R = int(0);
            vals_i__ = context__.vals_i("R");
            pos__ = 0;
            R = vals_i__[pos__++];
            check_greater_or_equal(function__, "R", R, 1);
            check_less_or_equal(function__, "R", R, J);
            current_statement_begin__ = 10;
            validate_non_negative_index("Y", "N_obs", N_obs);
            context__.validate_dims("data initialization", "Y", "int", context__.to_vec(N_obs));
            Y = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("Y");
            pos__ = 0;
            size_t Y_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < Y_k_0_max__; ++k_0__) {
                Y[k_0__] = vals_i__[pos__++];
            }
            size_t Y_i_0_max__ = N_obs;
            for (size_t i_0__ = 0; i_0__ < Y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "Y[i_0__]", Y[i_0__], -(B));
                check_less_or_equal(function__, "Y[i_0__]", Y[i_0__], B);
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("V", "N", N);
            context__.validate_dims("data initialization", "V", "vector_d", context__.to_vec(N));
            V = Eigen::Matrix<double, Eigen::Dynamic, 1>(N);
            vals_r__ = context__.vals_r("V");
            pos__ = 0;
            size_t V_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < V_j_1_max__; ++j_1__) {
                V(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "V", V, -(B));
            check_less_or_equal(function__, "V", V, B);
            current_statement_begin__ = 12;
            context__.validate_dims("data initialization", "CV", "int", context__.to_vec());
            CV = int(0);
            vals_i__ = context__.vals_i("CV");
            pos__ = 0;
            CV = vals_i__[pos__++];
            check_greater_or_equal(function__, "CV", CV, 0);
            check_less_or_equal(function__, "CV", CV, 1);
            current_statement_begin__ = 13;
            validate_non_negative_index("holdout", "N_obs", N_obs);
            context__.validate_dims("data initialization", "holdout", "int", context__.to_vec(N_obs));
            holdout = std::vector<int>(N_obs, int(0));
            vals_i__ = context__.vals_i("holdout");
            pos__ = 0;
            size_t holdout_k_0_max__ = N_obs;
            for (size_t k_0__ = 0; k_0__ < holdout_k_0_max__; ++k_0__) {
                holdout[k_0__] = vals_i__[pos__++];
            }
            size_t holdout_i_0_max__ = N_obs;
            for (size_t i_0__ = 0; i_0__ < holdout_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "holdout[i_0__]", holdout[i_0__], 0);
                check_less_or_equal(function__, "holdout[i_0__]", holdout[i_0__], 1);
            }
            // initialize transformed data variables
            current_statement_begin__ = 17;
            sigma_alpha_prior_rate = double(0);
            stan::math::fill(sigma_alpha_prior_rate, DUMMY_VAR__);
            stan::math::assign(sigma_alpha_prior_rate,((2 - 1) / (B / 5.0)));
            current_statement_begin__ = 18;
            tau_prior_rate = double(0);
            stan::math::fill(tau_prior_rate, DUMMY_VAR__);
            stan::math::assign(tau_prior_rate,((2 - 1) / (B / 5.0)));
            // execute transformed data statements
            // validate transformed data
            current_statement_begin__ = 17;
            check_greater_or_equal(function__, "sigma_alpha_prior_rate", sigma_alpha_prior_rate, 0);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__, "tau_prior_rate", tau_prior_rate, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 22;
            validate_non_negative_index("alpha_raw", "N", N);
            validate_non_negative_index("alpha_raw", "2", 2);
            num_params_r__ += (N * 2);
            current_statement_begin__ = 23;
            validate_non_negative_index("beta_raw", "N", N);
            validate_non_negative_index("beta_raw", "2", 2);
            num_params_r__ += (N * 2);
            current_statement_begin__ = 24;
            validate_non_negative_index("theta_lr", "2", 2);
            num_params_r__ += 2;
            current_statement_begin__ = 25;
            validate_non_negative_index("theta_raw", "J", J);
            num_params_r__ += (1 * J);
            current_statement_begin__ = 26;
            num_params_r__ += 1;
            current_statement_begin__ = 27;
            num_params_r__ += 1;
            current_statement_begin__ = 28;
            num_params_r__ += 1;
            current_statement_begin__ = 29;
            validate_non_negative_index("lambda", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 30;
            num_params_r__ += 1;
            current_statement_begin__ = 31;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_HBAM_MINI() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 22;
        if (!(context__.contains_r("alpha_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha_raw");
        pos__ = 0U;
        validate_non_negative_index("alpha_raw", "N", N);
        validate_non_negative_index("alpha_raw", "2", 2);
        context__.validate_dims("parameter initialization", "alpha_raw", "matrix_d", context__.to_vec(N,2));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> alpha_raw(N, 2);
        size_t alpha_raw_j_2_max__ = 2;
        size_t alpha_raw_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < alpha_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < alpha_raw_j_1_max__; ++j_1__) {
                alpha_raw(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(alpha_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 23;
        if (!(context__.contains_r("beta_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_raw");
        pos__ = 0U;
        validate_non_negative_index("beta_raw", "N", N);
        validate_non_negative_index("beta_raw", "2", 2);
        context__.validate_dims("parameter initialization", "beta_raw", "matrix_d", context__.to_vec(N,2));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta_raw(N, 2);
        size_t beta_raw_j_2_max__ = 2;
        size_t beta_raw_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                beta_raw(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(beta_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 24;
        if (!(context__.contains_r("theta_lr")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta_lr missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta_lr");
        pos__ = 0U;
        validate_non_negative_index("theta_lr", "2", 2);
        context__.validate_dims("parameter initialization", "theta_lr", "vector_d", context__.to_vec(2));
        Eigen::Matrix<double, Eigen::Dynamic, 1> theta_lr(2);
        size_t theta_lr_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < theta_lr_j_1_max__; ++j_1__) {
            theta_lr(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.ordered_unconstrain(theta_lr);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta_lr: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 25;
        if (!(context__.contains_r("theta_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta_raw");
        pos__ = 0U;
        validate_non_negative_index("theta_raw", "J", J);
        context__.validate_dims("parameter initialization", "theta_raw", "double", context__.to_vec(J));
        std::vector<double> theta_raw(J, double(0));
        size_t theta_raw_k_0_max__ = J;
        for (size_t k_0__ = 0; k_0__ < theta_raw_k_0_max__; ++k_0__) {
            theta_raw[k_0__] = vals_r__[pos__++];
        }
        size_t theta_raw_i_0_max__ = J;
        for (size_t i_0__ = 0; i_0__ < theta_raw_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(theta_raw[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta_raw: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 26;
        if (!(context__.contains_r("sigma_alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_alpha");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_alpha", "double", context__.to_vec());
        double sigma_alpha(0);
        sigma_alpha = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 27;
        if (!(context__.contains_r("sigma_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_beta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_beta", "double", context__.to_vec());
        double sigma_beta(0);
        sigma_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0, 2, sigma_beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 28;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "tau", "double", context__.to_vec());
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 29;
        if (!(context__.contains_r("lambda")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0U;
        validate_non_negative_index("lambda", "N", N);
        context__.validate_dims("parameter initialization", "lambda", "vector_d", context__.to_vec(N));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda(N);
        size_t lambda_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            lambda(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, lambda);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 30;
        if (!(context__.contains_r("psi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable psi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "psi", "double", context__.to_vec());
        double psi(0);
        psi = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(.5, 1, psi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable psi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 31;
        if (!(context__.contains_r("delta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable delta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "delta", "double", context__.to_vec());
        double delta(0);
        delta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(2, 100, delta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable delta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 22;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> alpha_raw;
            (void) alpha_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha_raw = in__.matrix_constrain(N, 2, lp__);
            else
                alpha_raw = in__.matrix_constrain(N, 2);
            current_statement_begin__ = 23;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta_raw;
            (void) beta_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_raw = in__.matrix_constrain(N, 2, lp__);
            else
                beta_raw = in__.matrix_constrain(N, 2);
            current_statement_begin__ = 24;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_lr;
            (void) theta_lr;  // dummy to suppress unused var warning
            if (jacobian__)
                theta_lr = in__.ordered_constrain(2, lp__);
            else
                theta_lr = in__.ordered_constrain(2);
            current_statement_begin__ = 25;
            std::vector<local_scalar_t__> theta_raw;
            size_t theta_raw_d_0_max__ = J;
            theta_raw.reserve(theta_raw_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < theta_raw_d_0_max__; ++d_0__) {
                if (jacobian__)
                    theta_raw.push_back(in__.scalar_constrain(lp__));
                else
                    theta_raw.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 26;
            local_scalar_t__ sigma_alpha;
            (void) sigma_alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_alpha = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_alpha = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 27;
            local_scalar_t__ sigma_beta;
            (void) sigma_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_beta = in__.scalar_lub_constrain(0, 2, lp__);
            else
                sigma_beta = in__.scalar_lub_constrain(0, 2);
            current_statement_begin__ = 28;
            local_scalar_t__ tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.scalar_lb_constrain(0, lp__);
            else
                tau = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 29;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda;
            (void) lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda = in__.vector_lub_constrain(0, 1, N, lp__);
            else
                lambda = in__.vector_lub_constrain(0, 1, N);
            current_statement_begin__ = 30;
            local_scalar_t__ psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.scalar_lub_constrain(.5, 1, lp__);
            else
                psi = in__.scalar_lub_constrain(.5, 1);
            current_statement_begin__ = 31;
            local_scalar_t__ delta;
            (void) delta;  // dummy to suppress unused var warning
            if (jacobian__)
                delta = in__.scalar_lub_constrain(2, 100, lp__);
            else
                delta = in__.scalar_lub_constrain(2, 100);
            // transformed parameters
            current_statement_begin__ = 35;
            local_scalar_t__ alpha_lambda;
            (void) alpha_lambda;  // dummy to suppress unused var warning
            stan::math::initialize(alpha_lambda, DUMMY_VAR__);
            stan::math::fill(alpha_lambda, DUMMY_VAR__);
            stan::math::assign(alpha_lambda,(delta * psi));
            current_statement_begin__ = 36;
            local_scalar_t__ beta_lambda;
            (void) beta_lambda;  // dummy to suppress unused var warning
            stan::math::initialize(beta_lambda, DUMMY_VAR__);
            stan::math::fill(beta_lambda, DUMMY_VAR__);
            stan::math::assign(beta_lambda,(delta * (1 - psi)));
            current_statement_begin__ = 37;
            validate_non_negative_index("theta", "J", J);
            std::vector<local_scalar_t__> theta(J, local_scalar_t__(0));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 38;
            validate_non_negative_index("alpha0", "N", N);
            validate_non_negative_index("alpha0", "2", 2);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> alpha0(N, 2);
            stan::math::initialize(alpha0, DUMMY_VAR__);
            stan::math::fill(alpha0, DUMMY_VAR__);
            current_statement_begin__ = 39;
            validate_non_negative_index("beta0", "N", N);
            validate_non_negative_index("beta0", "2", 2);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta0(N, 2);
            stan::math::initialize(beta0, DUMMY_VAR__);
            stan::math::fill(beta0, DUMMY_VAR__);
            current_statement_begin__ = 40;
            validate_non_negative_index("chi0", "N", N);
            validate_non_negative_index("chi0", "2", 2);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> chi0(N, 2);
            stan::math::initialize(chi0, DUMMY_VAR__);
            stan::math::fill(chi0, DUMMY_VAR__);
            current_statement_begin__ = 41;
            validate_non_negative_index("log_lik", "N_obs", N_obs);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(N_obs);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 42;
            stan::math::assign(theta, theta_raw);
            current_statement_begin__ = 43;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(L), stan::model::nil_index_list()), 
                        get_base1(theta_lr, 1, "theta_lr", 1), 
                        "assigning variable theta");
            current_statement_begin__ = 44;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(R), stan::model::nil_index_list()), 
                        get_base1(theta_lr, 2, "theta_lr", 1), 
                        "assigning variable theta");
            current_statement_begin__ = 45;
            stan::model::assign(alpha0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        multiply(stan::model::rvalue(alpha_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "alpha_raw"), sigma_alpha), 
                        "assigning variable alpha0");
            current_statement_begin__ = 46;
            stan::model::assign(alpha0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                        multiply(stan::model::rvalue(alpha_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "alpha_raw"), sigma_alpha), 
                        "assigning variable alpha0");
            current_statement_begin__ = 47;
            stan::model::assign(beta0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        stan::math::exp(multiply(stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta_raw"), sigma_beta)), 
                        "assigning variable beta0");
            current_statement_begin__ = 48;
            stan::model::assign(beta0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                        minus(stan::math::exp(multiply(stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "beta_raw"), sigma_beta))), 
                        "assigning variable beta0");
            current_statement_begin__ = 49;
            stan::model::assign(chi0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        elt_divide(subtract(V, stan::model::rvalue(alpha0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "alpha0")), stan::model::rvalue(beta0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta0")), 
                        "assigning variable chi0");
            current_statement_begin__ = 50;
            stan::model::assign(chi0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                        elt_divide(subtract(V, stan::model::rvalue(alpha0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "alpha0")), stan::model::rvalue(beta0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "beta0")), 
                        "assigning variable chi0");
            current_statement_begin__ = 52;
            for (int n = 1; n <= N_obs; ++n) {
                current_statement_begin__ = 53;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            log_mix(get_base1(lambda, get_base1(ii, n, "ii", 1), "lambda", 1), normal_log(get_base1(Y, n, "Y", 1), (get_base1(alpha0, get_base1(ii, n, "ii", 1), 1, "alpha0", 1) + (get_base1(beta0, get_base1(ii, n, "ii", 1), 1, "beta0", 1) * get_base1(theta, get_base1(jj, n, "jj", 1), "theta", 1))), tau), normal_log(get_base1(Y, n, "Y", 1), (get_base1(alpha0, get_base1(ii, n, "ii", 1), 2, "alpha0", 1) + (get_base1(beta0, get_base1(ii, n, "ii", 1), 2, "beta0", 1) * get_base1(theta, get_base1(jj, n, "jj", 1), "theta", 1))), tau)), 
                            "assigning variable log_lik");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 35;
            if (stan::math::is_uninitialized(alpha_lambda)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: alpha_lambda";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable alpha_lambda: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "alpha_lambda", alpha_lambda, 0);
            current_statement_begin__ = 36;
            if (stan::math::is_uninitialized(beta_lambda)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: beta_lambda";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta_lambda: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "beta_lambda", beta_lambda, 0);
            current_statement_begin__ = 37;
            size_t theta_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(theta[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 38;
            size_t alpha0_j_1_max__ = N;
            size_t alpha0_j_2_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < alpha0_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < alpha0_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(alpha0(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: alpha0" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable alpha0: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 39;
            size_t beta0_j_1_max__ = N;
            size_t beta0_j_2_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < beta0_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(beta0(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: beta0" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta0: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 40;
            size_t chi0_j_1_max__ = N;
            size_t chi0_j_2_max__ = 2;
            for (size_t j_1__ = 0; j_1__ < chi0_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < chi0_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(chi0(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: chi0" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable chi0: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 41;
            size_t log_lik_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(log_lik(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: log_lik" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable log_lik: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 60;
            lp_accum__.add(normal_log<propto__>(theta_raw, 0, B));
            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(theta_lr, 0, B));
            current_statement_begin__ = 62;
            lp_accum__.add(normal_log<propto__>(stan::model::rvalue(alpha_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "alpha_raw"), 0, 1));
            current_statement_begin__ = 63;
            lp_accum__.add(normal_log<propto__>(stan::model::rvalue(alpha_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "alpha_raw"), 0, 1));
            current_statement_begin__ = 64;
            lp_accum__.add(gamma_log<propto__>(sigma_alpha, 2, sigma_alpha_prior_rate));
            current_statement_begin__ = 65;
            lp_accum__.add(normal_log<propto__>(stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta_raw"), 0, 1));
            current_statement_begin__ = 66;
            lp_accum__.add(normal_log<propto__>(stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "beta_raw"), 0, 1));
            current_statement_begin__ = 67;
            lp_accum__.add(gamma_log<propto__>(sigma_beta, 3, 10));
            current_statement_begin__ = 68;
            lp_accum__.add(gamma_log<propto__>(tau, 2, tau_prior_rate));
            current_statement_begin__ = 69;
            lp_accum__.add(beta_log<propto__>(lambda, alpha_lambda, beta_lambda));
            current_statement_begin__ = 70;
            lp_accum__.add(beta_log<propto__>(psi, 8.5, 1.5));
            current_statement_begin__ = 71;
            lp_accum__.add(gamma_log<propto__>((delta - 2), 2, .1));
            current_statement_begin__ = 73;
            if (as_bool(logical_eq(CV, 0))) {
                current_statement_begin__ = 74;
                lp_accum__.add(sum(log_lik));
            } else {
                current_statement_begin__ = 76;
                for (int n = 1; n <= N_obs; ++n) {
                    current_statement_begin__ = 77;
                    if (as_bool(logical_eq(get_base1(holdout, n, "holdout", 1), 0))) {
                        current_statement_begin__ = 78;
                        lp_accum__.add(get_base1(log_lik, n, "log_lik", 1));
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha_raw");
        names__.push_back("beta_raw");
        names__.push_back("theta_lr");
        names__.push_back("theta_raw");
        names__.push_back("sigma_alpha");
        names__.push_back("sigma_beta");
        names__.push_back("tau");
        names__.push_back("lambda");
        names__.push_back("psi");
        names__.push_back("delta");
        names__.push_back("alpha_lambda");
        names__.push_back("beta_lambda");
        names__.push_back("theta");
        names__.push_back("alpha0");
        names__.push_back("beta0");
        names__.push_back("chi0");
        names__.push_back("log_lik");
        names__.push_back("kappa");
        names__.push_back("chi");
        names__.push_back("alpha");
        names__.push_back("beta");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(2);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N_obs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_HBAM_MINI_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> alpha_raw = in__.matrix_constrain(N, 2);
        size_t alpha_raw_j_2_max__ = 2;
        size_t alpha_raw_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < alpha_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < alpha_raw_j_1_max__; ++j_1__) {
                vars__.push_back(alpha_raw(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta_raw = in__.matrix_constrain(N, 2);
        size_t beta_raw_j_2_max__ = 2;
        size_t beta_raw_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                vars__.push_back(beta_raw(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> theta_lr = in__.ordered_constrain(2);
        size_t theta_lr_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < theta_lr_j_1_max__; ++j_1__) {
            vars__.push_back(theta_lr(j_1__));
        }
        std::vector<double> theta_raw;
        size_t theta_raw_d_0_max__ = J;
        theta_raw.reserve(theta_raw_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < theta_raw_d_0_max__; ++d_0__) {
            theta_raw.push_back(in__.scalar_constrain());
        }
        size_t theta_raw_k_0_max__ = J;
        for (size_t k_0__ = 0; k_0__ < theta_raw_k_0_max__; ++k_0__) {
            vars__.push_back(theta_raw[k_0__]);
        }
        double sigma_alpha = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_alpha);
        double sigma_beta = in__.scalar_lub_constrain(0, 2);
        vars__.push_back(sigma_beta);
        double tau = in__.scalar_lb_constrain(0);
        vars__.push_back(tau);
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda = in__.vector_lub_constrain(0, 1, N);
        size_t lambda_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            vars__.push_back(lambda(j_1__));
        }
        double psi = in__.scalar_lub_constrain(.5, 1);
        vars__.push_back(psi);
        double delta = in__.scalar_lub_constrain(2, 100);
        vars__.push_back(delta);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 35;
            double alpha_lambda;
            (void) alpha_lambda;  // dummy to suppress unused var warning
            stan::math::initialize(alpha_lambda, DUMMY_VAR__);
            stan::math::fill(alpha_lambda, DUMMY_VAR__);
            stan::math::assign(alpha_lambda,(delta * psi));
            current_statement_begin__ = 36;
            double beta_lambda;
            (void) beta_lambda;  // dummy to suppress unused var warning
            stan::math::initialize(beta_lambda, DUMMY_VAR__);
            stan::math::fill(beta_lambda, DUMMY_VAR__);
            stan::math::assign(beta_lambda,(delta * (1 - psi)));
            current_statement_begin__ = 37;
            validate_non_negative_index("theta", "J", J);
            std::vector<double> theta(J, double(0));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            current_statement_begin__ = 38;
            validate_non_negative_index("alpha0", "N", N);
            validate_non_negative_index("alpha0", "2", 2);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> alpha0(N, 2);
            stan::math::initialize(alpha0, DUMMY_VAR__);
            stan::math::fill(alpha0, DUMMY_VAR__);
            current_statement_begin__ = 39;
            validate_non_negative_index("beta0", "N", N);
            validate_non_negative_index("beta0", "2", 2);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta0(N, 2);
            stan::math::initialize(beta0, DUMMY_VAR__);
            stan::math::fill(beta0, DUMMY_VAR__);
            current_statement_begin__ = 40;
            validate_non_negative_index("chi0", "N", N);
            validate_non_negative_index("chi0", "2", 2);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> chi0(N, 2);
            stan::math::initialize(chi0, DUMMY_VAR__);
            stan::math::fill(chi0, DUMMY_VAR__);
            current_statement_begin__ = 41;
            validate_non_negative_index("log_lik", "N_obs", N_obs);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(N_obs);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 42;
            stan::math::assign(theta, theta_raw);
            current_statement_begin__ = 43;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(L), stan::model::nil_index_list()), 
                        get_base1(theta_lr, 1, "theta_lr", 1), 
                        "assigning variable theta");
            current_statement_begin__ = 44;
            stan::model::assign(theta, 
                        stan::model::cons_list(stan::model::index_uni(R), stan::model::nil_index_list()), 
                        get_base1(theta_lr, 2, "theta_lr", 1), 
                        "assigning variable theta");
            current_statement_begin__ = 45;
            stan::model::assign(alpha0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        multiply(stan::model::rvalue(alpha_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "alpha_raw"), sigma_alpha), 
                        "assigning variable alpha0");
            current_statement_begin__ = 46;
            stan::model::assign(alpha0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                        multiply(stan::model::rvalue(alpha_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "alpha_raw"), sigma_alpha), 
                        "assigning variable alpha0");
            current_statement_begin__ = 47;
            stan::model::assign(beta0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        stan::math::exp(multiply(stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta_raw"), sigma_beta)), 
                        "assigning variable beta0");
            current_statement_begin__ = 48;
            stan::model::assign(beta0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                        minus(stan::math::exp(multiply(stan::model::rvalue(beta_raw, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "beta_raw"), sigma_beta))), 
                        "assigning variable beta0");
            current_statement_begin__ = 49;
            stan::model::assign(chi0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                        elt_divide(subtract(V, stan::model::rvalue(alpha0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "alpha0")), stan::model::rvalue(beta0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta0")), 
                        "assigning variable chi0");
            current_statement_begin__ = 50;
            stan::model::assign(chi0, 
                        stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                        elt_divide(subtract(V, stan::model::rvalue(alpha0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "alpha0")), stan::model::rvalue(beta0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "beta0")), 
                        "assigning variable chi0");
            current_statement_begin__ = 52;
            for (int n = 1; n <= N_obs; ++n) {
                current_statement_begin__ = 53;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            log_mix(get_base1(lambda, get_base1(ii, n, "ii", 1), "lambda", 1), normal_log(get_base1(Y, n, "Y", 1), (get_base1(alpha0, get_base1(ii, n, "ii", 1), 1, "alpha0", 1) + (get_base1(beta0, get_base1(ii, n, "ii", 1), 1, "beta0", 1) * get_base1(theta, get_base1(jj, n, "jj", 1), "theta", 1))), tau), normal_log(get_base1(Y, n, "Y", 1), (get_base1(alpha0, get_base1(ii, n, "ii", 1), 2, "alpha0", 1) + (get_base1(beta0, get_base1(ii, n, "ii", 1), 2, "beta0", 1) * get_base1(theta, get_base1(jj, n, "jj", 1), "theta", 1))), tau)), 
                            "assigning variable log_lik");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 35;
            check_greater_or_equal(function__, "alpha_lambda", alpha_lambda, 0);
            current_statement_begin__ = 36;
            check_greater_or_equal(function__, "beta_lambda", beta_lambda, 0);
            // write transformed parameters
            if (include_tparams__) {
                vars__.push_back(alpha_lambda);
                vars__.push_back(beta_lambda);
                size_t theta_k_0_max__ = J;
                for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                    vars__.push_back(theta[k_0__]);
                }
                size_t alpha0_j_2_max__ = 2;
                size_t alpha0_j_1_max__ = N;
                for (size_t j_2__ = 0; j_2__ < alpha0_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < alpha0_j_1_max__; ++j_1__) {
                        vars__.push_back(alpha0(j_1__, j_2__));
                    }
                }
                size_t beta0_j_2_max__ = 2;
                size_t beta0_j_1_max__ = N;
                for (size_t j_2__ = 0; j_2__ < beta0_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
                        vars__.push_back(beta0(j_1__, j_2__));
                    }
                }
                size_t chi0_j_2_max__ = 2;
                size_t chi0_j_1_max__ = N;
                for (size_t j_2__ = 0; j_2__ < chi0_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < chi0_j_1_max__; ++j_1__) {
                        vars__.push_back(chi0(j_1__, j_2__));
                    }
                }
                size_t log_lik_j_1_max__ = N_obs;
                for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                    vars__.push_back(log_lik(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 83;
            validate_non_negative_index("kappa", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> kappa(N);
            stan::math::initialize(kappa, DUMMY_VAR__);
            stan::math::fill(kappa, DUMMY_VAR__);
            stan::math::assign(kappa,to_vector(bernoulli_rng(lambda, base_rng__)));
            current_statement_begin__ = 84;
            validate_non_negative_index("chi", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> chi(N);
            stan::math::initialize(chi, DUMMY_VAR__);
            stan::math::fill(chi, DUMMY_VAR__);
            stan::math::assign(chi,add(elt_multiply(kappa, stan::model::rvalue(chi0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "chi0")), elt_multiply(subtract(1, kappa), stan::model::rvalue(chi0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "chi0"))));
            current_statement_begin__ = 85;
            validate_non_negative_index("alpha", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> alpha(N);
            stan::math::initialize(alpha, DUMMY_VAR__);
            stan::math::fill(alpha, DUMMY_VAR__);
            stan::math::assign(alpha,add(elt_multiply(kappa, stan::model::rvalue(alpha0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "alpha0")), elt_multiply(subtract(1, kappa), stan::model::rvalue(alpha0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "alpha0"))));
            current_statement_begin__ = 86;
            validate_non_negative_index("beta", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta(N);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            stan::math::assign(beta,add(elt_multiply(kappa, stan::model::rvalue(beta0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "beta0")), elt_multiply(subtract(1, kappa), stan::model::rvalue(beta0, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "beta0"))));
            // validate, write generated quantities
            current_statement_begin__ = 83;
            size_t kappa_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < kappa_j_1_max__; ++j_1__) {
                vars__.push_back(kappa(j_1__));
            }
            current_statement_begin__ = 84;
            size_t chi_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < chi_j_1_max__; ++j_1__) {
                vars__.push_back(chi(j_1__));
            }
            current_statement_begin__ = 85;
            size_t alpha_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
                vars__.push_back(alpha(j_1__));
            }
            current_statement_begin__ = 86;
            size_t beta_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                vars__.push_back(beta(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_HBAM_MINI";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_raw_j_2_max__ = 2;
        size_t alpha_raw_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < alpha_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < alpha_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_raw_j_2_max__ = 2;
        size_t beta_raw_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t theta_lr_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < theta_lr_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_lr" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_raw_k_0_max__ = J;
        for (size_t k_0__ = 0; k_0__ < theta_raw_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_raw" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        size_t lambda_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_lambda";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_lambda";
            param_names__.push_back(param_name_stream__.str());
            size_t theta_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t alpha0_j_2_max__ = 2;
            size_t alpha0_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < alpha0_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < alpha0_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "alpha0" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t beta0_j_2_max__ = 2;
            size_t beta0_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < beta0_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta0" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t chi0_j_2_max__ = 2;
            size_t chi0_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < chi0_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < chi0_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "chi0" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t log_lik_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t kappa_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < kappa_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t chi_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < chi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "chi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_raw_j_2_max__ = 2;
        size_t alpha_raw_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < alpha_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < alpha_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "alpha_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta_raw_j_2_max__ = 2;
        size_t beta_raw_j_1_max__ = N;
        for (size_t j_2__ = 0; j_2__ < beta_raw_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta_raw" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t theta_lr_j_1_max__ = 2;
        for (size_t j_1__ = 0; j_1__ < theta_lr_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_lr" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_raw_k_0_max__ = J;
        for (size_t k_0__ = 0; k_0__ < theta_raw_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_raw" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        size_t lambda_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < lambda_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha_lambda";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_lambda";
            param_names__.push_back(param_name_stream__.str());
            size_t theta_k_0_max__ = J;
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t alpha0_j_2_max__ = 2;
            size_t alpha0_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < alpha0_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < alpha0_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "alpha0" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t beta0_j_2_max__ = 2;
            size_t beta0_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < beta0_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta0" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t chi0_j_2_max__ = 2;
            size_t chi0_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < chi0_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < chi0_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "chi0" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t log_lik_j_1_max__ = N_obs;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t kappa_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < kappa_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kappa" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t chi_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < chi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "chi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t alpha_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_HBAM_MINI_namespace::model_HBAM_MINI stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
