% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haven.R
\name{read_sas}
\alias{read_sas}
\alias{write_sas}
\title{Read and write SAS files.}
\usage{
read_sas(data_file, catalog_file = NULL, encoding = NULL,
  cols_only = NULL)

write_sas(data, path)
}
\arguments{
\item{data_file, catalog_file}{Path to data and catalog files. The files are
processed with \code{\link[readr]{datasource}()}.}

\item{encoding}{The character encoding used for the file. This defaults to
the encoding specified in the file, or UTF-8. You can use this argument
to override the value stored in the file if it is correct}

\item{cols_only}{A character vector giving an experimental way to read in
only specified columns.}

\item{data}{Data frame to write.}

\item{path}{Path to file where the data will be written.}
}
\value{
A tibble, data frame variant with nice defaults.

  Variable labels are stored in the "label" attribute of each variable.
  It is not printed on the console, but the RStudio viewer will show it.
}
\description{
Reading supports both sas7bdat files and the accompanying sas7bdat files
that SAS uses to record value labels. Writing value labels is not currently
supported.
}
\examples{
path <- system.file("examples", "iris.sas7bdat", package = "haven")
read_sas(path)
}
