#' Central Idaho Water Temperature Data
#'
#' @description
#' Water temperature data from Isaak et al. (2018).  Generally covers the
#' Boise, Payette, Clearwater, and upper Salmon River watersheds.
#'
#' @source https://hess.copernicus.org/articles/22/6225/2018/
#' @format Data frame
#' \describe{
#' \item{date}{Date measurement was taken.}
#' \item{site}{Site ID.}
#' \item{temp_c}{Temperature in degrees Celsius.}
#' }
#' @examples
#' idaho
#' @references
#' Isaak, D.J., Luce, C.H., Chandler, G.L., Horan, D.L., Wollrab, S.P. (1990).
#' Principal components of thermal regimes in mountain river networks.
#'   \emph{Hydrology and Earth System Sciences},
#'   \bold{22(12)}, 6225--6240.
"idaho"
