% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hasse.R
\name{hasse}
\alias{hasse}
\title{Draw Hasse diagram}
\usage{
hasse(data, labels = c(), parameters = list())
}
\arguments{
\item{data}{\emph{n} x \emph{n} matrix, which represents partial order of \emph{n}
elements in set. Each cell \code{[i, j]} has value \code{TRUE}
iff \emph{i}-th element precedes \emph{j}-th element.}

\item{labels}{Vector containing labels of elements. If missing or \code{NULL} then
\code{data} row names will be used as labels. If \code{rownames(data)} are not present,
the labels will be generated as ('a' + element index).}

\item{parameters}{List with named elements:
\itemize{
\item \code{arrow} -- direction of arrows: \code{"forward"}, \code{"backward"},
\code{"both"} or \code{"none"} (default \code{"forward"}),
\item \code{cluster} -- whether to cluster elements which have the same parents
and children and are connected all to all (see first commented example) (default \code{TRUE}),
\item \code{clusterMerge} -- merge clustered nodes
within single node frame (default \code{FALSE}),
\item \code{clusterNonAdjacent} -- to allow clustering elements 
that are not mutually adjacent (default \code{FALSE}),
\item \code{edgeColor} -- edge color, from colors() (default \code{"black"}),
\item \code{newpage} -- whether to call \code{grid.newpage()} before drawing
(default \code{TRUE}),
\item \code{nodeColor} -- node frame color, from colors() (default \code{"black"}),
\item \code{margin} -- node margins, a list with 4 numerical items: 
\code{"tb"} for top-bottom margin, \code{"rl"} for right-left margin,
\code{"otb"} and \code{"orl"} for outer margin when multiple labels are present,
\item \code{shape} -- shape of diagram nodes: \code{"roundrect"}, \code{"rect"}
or \code{"none"} (default \code{"roundrect"}),
\item \code{transitiveReduction} -- whether to perform transitive reduction
(default \code{TRUE}).
}}
}
\description{
This function draws Hasse diagram -- visualization of transitive reduction
of a finite partially ordered set.
}
\examples{
randomData <- generateRandomData(15, 2, 0.5)
hasse(randomData)

# Clustering example
data <- matrix(data = FALSE, ncol = 4, nrow = 4)
data[1, 2] = data[1, 3] = data[2, 4] = data[3, 4] = TRUE
data[2, 3] = data[3, 2] = TRUE
hasse(data, c(), list(cluster = TRUE))
hasse(data, c(), list(cluster = FALSE))

# Hasse to pdf example
# randomData <- generateRandomData(15, 2, 0.5)
# pdf("path-for-diagram.pdf")
# hasse(randomData, NULL, list(newpage = FALSE))
# dev.off()
}
