% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_hashmap.R
\name{save_hashmap}
\alias{save_hashmap}
\title{Save Hashmaps}
\usage{
save_hashmap(x, file, overwrite = TRUE, compress = FALSE)
}
\arguments{
\item{x}{an object created by a call to \code{hashmap}.}

\item{file}{a filename where the object's data will be saved.}

\item{overwrite}{if \code{TRUE} (default) and \code{file} exists,
it will be overwritten. If \code{FALSE} and \code{file} exists, an
error is thrown.}

\item{compress}{a logical value or the type of file compression to use;
defaults to \code{FALSE} for better performance. See \code{?saveRDS}
for details.}
}
\value{
Nothing on success; an error on failure.
}
\description{
\code{save_hashmap} writes a \code{Hashmap}'s data to the
 specified file, which can be passed to \code{\link{load_hashmap}} at a
 later point in time to recreate the object.
}
\details{
Saving is done by calling \code{base::saveRDS} on the object's
 \code{data.frame} representation, \code{x$data.frame()}. Attempting to
 save an empty \code{Hashmap} results in an error.
}
\examples{
H <- hashmap(sample(letters[1:10]), sample(1:10))
tf <- tempfile()

save_hashmap(H, tf)

inherits(
    try(save_hashmap(H, tf, FALSE), silent = TRUE),
    "try-error"
)

H$insert("zzzzz", 123L)
save_hashmap(H, tf)

load_hashmap(tf)
}
\seealso{
\code{\link{load_hashmap}}, \code{\link{saveRDS}}
}

