% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanr_red.R
\name{hanr_red}
\alias{hanr_red}
\title{Anomaly and change point detector using RED}
\usage{
hanr_red(sw_size = 30, noise = 0.001, trials = 5)
}
\arguments{
\item{sw_size}{sliding window size (default 30)}

\item{noise}{noise}

\item{trials}{trials}
}
\value{
\code{hanr_red} object
}
\description{
Anomaly and change point detection using RED
The RED model adjusts to the time series. Observations distant from the model are labeled as anomalies.
It wraps the EMD model presented in the hht library.
}
\examples{
library(daltoolbox)
library(zoo)

#loading the example database
data(examples_anomalies)

#Using simple example
dataset <- examples_anomalies$simple
head(dataset)

# setting up time series emd detector
model <- hanr_red()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
