% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_apicarto_gpu.R
\name{get_apicarto_plu}
\alias{get_apicarto_plu}
\title{Apicarto module Geoportail de l'urbanisme}
\usage{
get_apicarto_plu (x,
                  ressource = "zone-urba",
                  partition = NULL)
}
\arguments{
\item{x}{An object of clas \code{sf} or \code{sfc}. If NULL, \code{partition} must be filled by partition of PLU.}

\item{ressource}{A character from this list : "document", "zone-urba", "secteur-cc", "prescription-surf",
"prescription-lin", "prescription-pct", "info-surf", "info-lin", "info-pct". See detail for more info.}

\item{partition}{A character corresponding to PLU partition (can be retrieve using
\code{get_apicarto_plu(x, "document", partition = NULL)}). If \code{partition} is explicitely set, all PLU
features are returned and \code{geom} is override}
}
\value{
A object of class \code{sf}
}
\description{
Apicarto module Geoportail de l'urbanisme
}
\details{
\itemize{
\item \verb{"document'} :
\item \code{"zone-urba"} :
\item \code{"secteur-cc"} :
\item \code{"prescription-surf"} :
\item \code{"prescription-lin"} :
\item \code{"prescription-pct"} :
\item \code{"info-surf"} :
\item \code{"info-lin"} :
\item \code{"info-pct"} :
}
}
\examples{
\dontrun{
library(tmap)
library(sf)
point <- st_sfc(st_point(c(-0.4950188466302029, 45.428039987269926)), crs = 4326)

# If you know the partition (all PLU features are returned, geom is override)
partition <- "DU_17345"
poly <- get_apicarto_plu(x = NULL, ressource = "zone-urba", partition = partition)
qtm(poly)+qtm(point, symbols.col = "red", symbols.size = 2)

# If you don't know partition (only intersection between geom and PLU features is returned)
poly <- get_apicarto_plu(x = point, ressource = "zone-urba", partition = NULL)
qtm(poly)+qtm(point, symbols.col = "red", symbols.size = 2)

# If you wanna find partition
document <- get_apicarto_plu(point, ressource = "document", partition = NULL)
partition <- unique(document$partition)

# Get all prescription : /!\ prescription is different than zone-urba
partition <- "DU_17345"
ressources <- c("prescription-surf", "prescription-lin", "prescription-pct")

# I recommend to use purrr package for loop
library(purrr)
all_prescription <- map(.x = ressources,
                        .f = ~ get_apicarto_plu(point, .x, partition))
}

}
