% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_terms.R
\name{commons_terms}
\alias{commons_terms}
\alias{hansard_commons_terms}
\title{Parliamentary Thesaurus}
\usage{
commons_terms(search = NULL, class = NULL, extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = TRUE)

hansard_commons_terms(search = NULL, class = NULL, extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = TRUE)
}
\arguments{
\item{search}{A string to search the parliamentary thesaurus for.}

\item{class}{The class of definition to be returned Accepts one of
\code{'ID'}, \code{'ORG'}, \code{'SIT'}, \code{'NAME'}, \code{'LEG'},
\code{'CTP'}, \code{'PBT'} and \code{'TPG'}.  Defaults to \code{NULL}.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'}
and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, displayes messages on the console on the
progress of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with results from the parliamentary thesaurus.
}
\description{
Imports the parliamentary thesaurus. The API is rate limited to 5500
requests at a time, so some use of parameters is required.
}
\examples{
\dontrun{
x <- commons_terms(search = "estate")

x <- commons_terms(search = "estate", class = "ORG")
}

}
