% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/members_search.R
\name{members_search}
\alias{members_search}
\alias{hansard_members_search}
\title{Search for an MP or Lord by name and constituency}
\usage{
members_search(search = NULL, tidy = TRUE, tidy_style = "snake_case")

hansard_members_search(search = NULL, tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{search}{Accepts any string. Defaults to NULL. If NULL, returns a tibble with all members of both houses of parliament.}

\item{tidy}{Fix the variable names in the tibble to remove extra characters, superfluous text and convert variable names to snake_case. For the `members_search` function it also changes the '_about' column name to 'mnis_id' (or 'mnisId' or 'mnis.id', depending on the value of the `tidy_text` parameter, and removes the URL to preserve only the numerical ID. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with the results of the search.
}
\description{
Function searches for the string and returns a tibble with all matches from both houses of parliament. Returns all partial matches in the members' names, constituencies, twitter handle and webpage. The default search is NULL, which returns a tibble of all members of both houses, the same result as members('all').
}
\examples{
\dontrun{

x <- members_search('chris')

x <- members_search(search='chris')
}
}
\seealso{
\code{\link{members}}
}
\keyword{All}
\keyword{Members}
\keyword{Parliament}
\keyword{of}
